#!/usr/bin/perl -w
#
# Tests ProjectBuilder::Base functions

use strict;
use Test::More;

my $nt = 0;

my $url = "svn+ssh://account\@machine.sdom.tld:8080/path/to/file";
my ($scheme, $account, $host, $port, $path) = pb_get_uri($uri);

is($scheme, "svn+ssh", "pb_get_uri Test protocol");
$nt++;

is($account, "account", "pb_get_uri Test account");
$nt++;

is($host, "machine.sdom.tld", "pb_get_uri Test host");
$nt++;

is($port, "8080", "pb_get_uri Test port");
$nt++;

is($path, "/path/to/file", "pb_get_uri Test path");
$nt++;

done_testing($nt);
