#!/bin/bash

## SAMPLE. Change the mount points to match your environment
# - Jim - PROFILE_DIR=${sstk_mount}
# - Jim - PROFILE_TYPE=${sstk_mount_type}
# - Jim - test -n "$sstk_mount_options" && PROFILE_OPTS="-o $sstk_mount_options"

# - Jim - export PROFILENAME=${img}

## Internal Variables, do not modify
# - Jim - export TOOLKIT=/TOOLKIT
# - Jim - export PROFILE_MNT=/mnt/nfs
# - Jim - export HWDISC_FILE=/TOOLKIT/hpdiscovery.xml
# - Jim - export SERVERNAME=
# - Jim - export BOOTDEVNODE=

clear
echo "*** Capturing Configuration ***"

# - Jim - mkdir -p ${TOOLKIT}/data_files/
HWDISC_FILE=/tmp/hpdiscovery.xml
export TMPDIR=$(mktemp -t -d liveusb.XXXXXX)
mount -t vfat /dev/disk/by-label/LiveUSB $TMPDIR

sleep 5

echo ""
echo "Loading storage drivers for hardware"
# - Jim - cd ${TOOLKIT}
./load_modules.sh > /dev/null 2>&1


echo ""
echo "Pausing to allow drivers to finish loading"
sleep 15
echo ""

## rerun hardware discovery 
./hpdiscovery -f ${HWDISC_FILE} > /dev/null 2>&1
echo "Hardware Discovery saved to ${HWDISC_FILE}"


## use hwquery to fetch the SystemName and BootDeviceNode from hardware discovery file. ( extra " " are required ) 
export "`./hwquery ${HWDISC_FILE} allboards.xml SERVERTYPE=SystemName`"
export "`./hwquery ${HWDISC_FILE} allboards.xml BOOTDEVNODE=DevNode`";

echo "Server Type: ${SERVERTYPE}"

# - JIm - mkdir -p ${TOOLKIT}/data_files/
./conrep -s -f${TMPDIR}/data_files/conrep.dat > /dev/null 2>&1
if [ $? = 0 ] ; then
	echo "System Configuration saved to ${TMPDIR}/data_files/conrep.dat"
fi

./ifhw ${HWDISC_FILE} allboards.xml "PCI:Smart Array" 2> /dev/null
if [ $? = 0 ] ; then
	hpacuscripting -c ${TMPDIR}/data_files/cpqacuxe.dat
	if [ $? = 0 ] ; then
		echo "Array Configuration saved to ${TMPDIR}/data_files/cpqacuxe.dat"
	fi
else
	echo "No Smart Array detected, no ACU Configuration captured."
fi

# - JIm - cd ${TOOLKIT}
./ifhw ${HWDISC_FILE} allboards.xml "PCI:Integrated Lights-Out" 2> /dev/null
if [ $? = 0 ] ; then
	modprobe hpilo
	hponcfg -a -w ${TMPDIR}/data_files/hponcfg.dat 
	if [ $? = 0 ] ; then
		echo "Integrated Lights-Out Configuration Report saved to ${TMPDIR}/data_files/hponcfg.dat"
		echo " - this is not a RIBCL configuration script"
	fi
fi

./stop.sh
