#!/bin/bash

clear
echo "*** Deploying Configuration ***"

HWDISC_FILE=/tmp/hpdiscovery.xml
export TMPDIR=$(mktemp -t -d liveusb.XXXXXX)
mount -t vfat /dev/disk/by-label/LiveUSB $TMPDIR

echo ""
echo "Loading storage drivers for hardware"
./load_modules.sh

echo ""
echo "Pausing to allow drivers to finish loading"
sleep 15
echo ""

## rerun hardware discovery 
./hpdiscovery -f ${HWDISC_FILE}
echo "Hardware Discovery saved to ${HWDISC_FILE}"

## use hwquery to fetch the SystemName from hardware discovery file. ( extra " " are required ) 
export "`./hwquery ${HWDISC_FILE} allboards.xml SERVERTYPE=SystemName`";

echo "Server Type: ${SERVERTYPE}"

./conrep -l -f${TMPDIR}/data_files/conrep.dat
if [ $? = 0 ] ; then
	echo "System Configuration data_files/conrep.dat APPLIED"
else
	echo "System Configuration data_files/conrep.dat FAILED"
fi

./ifhw ${HWDISC_FILE} allboards.xml "PCI:Smart Array" 2> /dev/null
if [ $? = 0 ] ; then
	hpacuscripting -reset -i ${TMPDIR}/data_files/cpqacuxe.dat
	if [ $? = 0 ] ; then
		echo "Array Configuration data_files/cpqacuxe.dat APPLIED"
	else
		echo "Array Configuration data_files/cpqacuxe.dat FAILED"
	fi
else
	echo "No Smart Array detected, no ACU Configuration applied."
fi

./ifhw ${HWDISC_FILE} allboards.xml "PCI:Integrated Lights-Out" 2> /dev/null
if [ $? = 0 ] ; then
	modprobe hpilo
	hponcfg -f ${TMPDIR}/data_files/hponcfg.dat 
	if [ $? = 0 ] ; then
		echo "Integrated Lights-Out Configuration data_files/hponcfg.dat APPLIED"
	fi
fi

./stop.sh
