#!/bin/bash

DISK_LABEL="LiveUSB"

clear
echo "*** Deploying iLO Configuration only ***"

HWDISC_FILE=/tmp/hpdiscovery.xml
export TMPDIR=$(mktemp -t -d liveusb.XXXXXX)
mount -t vfat /dev/disk/by-label/${DISK_LABEL} $TMPDIR

echo ""
echo "Loading storage drivers for hardware"
./load_modules.sh

echo ""
echo "Pausing to allow drivers to finish loading"
sleep 15
echo ""

## rerun hardware discovery 
./hpdiscovery -f ${HWDISC_FILE}
echo "Hardware Discovery saved to ${HWDISC_FILE}"

## use hwquery to fetch the SystemName from hardware discovery file. ( extra " " are required ) 
export "`./hwquery ${HWDISC_FILE} allboards.xml SERVERTYPE=SystemName`";

echo "Server Type: ${SERVERTYPE}"

./ifhw ${HWDISC_FILE} allboards.xml "PCI:Integrated Lights-Out" 2> /dev/null
if [ $? = 0 ] ; then
	modprobe hpilo
	# First reset iLO to factory default
	# hponcfg -r
	# The apply minimal config
	hponcfg -f ${TMPDIR}/data_files/ilo.dat 
	if [ $? = 0 ] ; then
		echo "Integrated Lights-Out Configuration data_files/ilo.dat APPLIED"
	fi
fi
./stop.sh
