#!/usr/bin/perl -w
#
# Program to import a maildir kmail environement into a thunderbird one.
#
# Released under the GPLv2 or the Artistic license at your will.

use strict;
use File::Find;
use File::Copy;
use File::Basename;
use File::Path;
use File::Glob ':glob';

my $cmd="formail";
# CHANGE AS YOU WISH
my $oldroot = "/users/segolene/.Mail";
my $newroot = "/users/segolene/.thunderbird/qk2f4dl6.default/Mail/pop.home.musique-ancienne.org/";
# Is the newroot a file (1) or a dir (0)
my $nrisfile = 0;
my $debug = 0;
# END CHANGE

$debug++ if ((defined $ARGV[0]) && ($ARGV[0] eq "-v"));
print "DEBUG MODE, not doing anything, just printing\n" if ($debug);
if ($debug) { 
	print "TARGET DIR: mkdir -p $newroot\n" if ((not -d "$newroot") && (not $nrisfile));
	print "CMD: mkdir -p $newroot\n" if ((not -d "$newroot") && (not $nrisfile));
} else {
	mkpath("$newroot",0, 0755) if ((not -d "$newroot") && (not $nrisfile));
}
system("$cmd </dev/null >/dev/null 2>/dev/null") == 0 or die "cannot find formail on your \$PATH!\nTry installing procmail\nAborting";

find(\&md2mb,($oldroot));

if ((-z "$newroot/Inbox") || (! -e "$newroot/Inbox")) {
	print "Renaming inbox into Inbox\n";
	move("$newroot/inbox","$newroot/Inbox") if (-e "$newroot/inbox");
}

sub md2mb {

if (-f $File::Find::name) {
	if (($File::Find::name =~ /\.ids$/) ||
		($File::Find::name =~ /\.sorted$/) ||
		($File::Find::name =~ /\.index$/)) {
		print "SKIP FILE: $File::Find::name\n" if ($debug);
		return;
	}
}
if (-d $File::Find::name) {
	if (($File::Find::name =~ /\/cur$/) ||
		($File::Find::name =~ /\/new$/) ||
		($File::Find::name =~ /\/tmp$/)) {
		print "SKIP DIR: $File::Find::name\n" if ($debug);
		return;
	}
}
my $destname = $File::Find::name;
# Target name is under a different root dir
$destname =~ s|^$oldroot||;
# Target name is not under a .directory dir but under a .sdb one
$destname =~ s|\.([^/]+)\.directory/|$1.sbd/|g;
# Here we create the target dir and target name
my $outputfile="$newroot/$destname";
my $cdir = dirname("$outputfile");
# Handle case where target file name is empty
$outputfile="$newroot" if ($destname =~ /^\s*$/);
# When we treat a dir, we will have to handle what it has below
if (-d $File::Find::name) {
	if ($debug) { 
  		print "DIR SRC: $File::Find::name\n";
	}
	my @files = (bsd_glob("$File::Find::name/cur/*"),bsd_glob("$File::Find::name/new/*"));
	if (@files) {
		if ($debug) { 
			print "DIR ($File::Find::name) DIR TARGET: mkdir -p $cdir\n" if (not -d "$cdir");
		} else {
			mkpath("$cdir",0, 0755) if (not -d "$cdir");
		}
	}
	foreach my $file (@files) {
  		next unless -f $file; # skip non-regular files
  		next unless -s $file; # skip empty files
  		next unless -r $file; # skip unreadable files
  		$file =~ s/'/'"'"'/g;  # escape ' (single quote)
		# NOTE! The output file must not contain single quotes (')!
  		my $run = "cat '$file' | $cmd >> '$outputfile'";
		if ($debug) { 
			print "COPYING CONTENT maildir($file) to $outputfile\n";
  			print "CMD: $run\n";
		} else {
			print "Copying maildir content from $file to $outputfile\n";
  			system($run) == 0 or warn "cannot run \"$run\".";
		}
	}
}
if (-f $File::Find::name) {
	if (($File::Find::name =~ /\/cur\//) ||
		($File::Find::name =~ /\/new\//) ||
		($File::Find::name =~ /\/tmp\//)) {
		print "SKIP FILE: $File::Find::name\n" if ($debug);
		return;
	}
	if ($debug) { 
		print "FILE ($File::Find::name) TARGET DIR: mkdir -p $cdir\n" if (not -d "$cdir");
  		print "CMD: cp $File::Find::name $cdir\n";
	} else {
		print "Copying mailbox content from $File::Find::name to $cdir\n";
		mkpath("$cdir",0, 0755) if (not -d "$cdir");
		copy($File::Find::name,$cdir);
	}
}
}
