#!/usr/bin/python

import getopt, sys, os
import xml.etree.ElementTree as ET
from xml.etree.ElementTree import Element

def cleanILOConf (tree):
	for userInfo in tree.findall(".//USER_INFO"):
		for user in userInfo.getiterator ("ADD_USER"):
			userInfo.remove (user)
	login = tree.find (".//LOGIN")
	sso = login.find ("./SSO_INFO")
	if not sso is None:
		login.remove (sso)
	return tree

def createUserInfo (tree):
	login = tree.find (".//LOGIN")
	return ET.SubElement (login, "USER_INFO", {"MODE": "write"})

def modAdminUser (tree, passwd):
	userInfo = tree.find (".//USER_INFO")
	if userInfo is None:
		userInfo = createUserInfo (tree)
	modUser = ET.SubElement (userInfo, "MOD_USER", { "USER_LOGIN": "Administrator"})
	ET.SubElement (modUser, "PASSWORD", { "value": passwd })
	ET.SubElement (modUser, "ADMIN_PRIV", { "value": "Yes" })
	ET.SubElement (modUser, "REMOTE_CONS_PRIV", { "value": "Yes" })
	ET.SubElement (modUser, "RESET_SERVER_PRIV", { "value": "Yes" })
	ET.SubElement (modUser, "VIRTUAL_MEDIA_PRIV", { "value": "Yes" })
	ET.SubElement (modUser, "CONFIG_ILO_PRIV", { "value": "Yes" })
	return tree

def modIP (tree, ip):
	ipAddr = tree.find (".//MOD_NETWORK_SETTINGS/IP_ADDRESS")
	ipAddr.set ("VALUE", ip)
	return tree

def modNetMask (tree, mask):
	netMask = tree.find (".//MOD_NETWORK_SETTINGS/SUBNET_MASK")
	netMask.set ("VALUE", mask)
	return tree

def modGateway (tree, gw):
	gwIP = tree.find (".//MOD_NETWORK_SETTINGS/GATEWAY_IP_ADDRESS")
	gwIP.set ("VALUE", gw)
	return tree

def addLicense (tree, key):
	ribInfo = tree.find (".//RIB_INFO")
	license = ET.SubElement (ribInfo, "LICENSE")
	ET.SubElement (license, "ACTIVATE", {"KEY": key})
	return tree

def forceReset (tree):
	login = tree.find ("./LOGIN")
	ribInfo = ET.SubElement (login, "RIB_INFO", {"MODE": "write"})
	ET.SubElement (ribInfo, "RESET_RIB")
	return tree

def main ():
	try:
		opts, args = getopt.getopt (sys.argv [1:], "p:l:", ["password=", "license=", "ip=", "netmask=", "gw="])
	except getopt.GetoptError, err:
		print str (err)
		sys.exit (2)
	password = key = ip = netmask = gw = None
	for o, a in opts:
		if o in ("-p", "--password"):
			password = a
		elif o in ("-l", "--license"):
			key = a
		elif o == "--ip":
			ip = a
		elif o == "--netmask":
			netmask = a
		elif o == "--gw":
			gw = a
	assert os.path.isfile (args [0])
	tree = ET.parse (args [0])
	cleanILOConf (tree)
	if password:
		modAdminUser (tree, password)
	if key:
		addLicense (tree, key)
	if ip:
		modIP (tree, ip)
	if netmask:
		modNetMask (tree, netmask)
	if gw:
		modGateway (tree, gw)

	# Force the iLO to reset
	forceReset (tree)

	print ET.tostring (tree.getroot ())
	

if __name__ == "__main__":
	main ()
