#!/bin/bash
# 
# This script captures the HP ProLiant BIOS,Smart Array RAID controllers
# and iLO configurations and saves them to a USB Key labeled LiveUSB
#
# October 2011
# 

clear
echo "*** Capturing Configuration ***"

[ -f /ssstk/ssstk-functions ] && . /ssstk/ssstk-functions

# Load the drivers and mount the USB key where the settings will be saved
ssstk_init

# Capturing ProLiant BIOS configuration
hp-conrep -s -f${BIOS_FILE} -x ${CONREP_XML} > /dev/null 2>&1
if [ $? = 0 ] ; then
	echo "System Configuration saved to ${BIOS_FILE##/tmp/*/}"
else
	echo "Failed to save configuration to ${BIOS_FILE##/tmp/*/}"
fi

# Check if a Smart Array controler is installed and capture its configuration
# hp-ifhw is buggy with hp-scripting.*.rpm
# hp-ifhw ${HWDISC_FILE} "$ALLBOARDS" "PCI:Smart Array" 2> /dev/null
$IFHW_CMD ${HWDISC_FILE} "$ALLBOARDS" "PCI:Smart Array" 2> /dev/null
if [ $? = 0 ] ; then
	hpacuscripting -c ${RAID_FILE}
	if [ $? = 0 ] ; then
		echo "Array Configuration saved to ${RAID_FILE##/tmp/*/}"
	else
		echo "Failed to save Array configuration to ${RAID_FILE##/tmp/*/}"
	fi
else
	echo "No Smart Array detected, no ACU Configuration captured."
fi

# Check if an iLO interface is present and save its configuration
$IFHW_CMD ${HWDISC_FILE} "$ALLBOARDS" "PCI:Integrated Lights-Out" 2> /dev/null
if [ $? = 0 ] ; then
	modprobe hpilo
	hponcfg -a -w ${ILO_FILE}
	if [ $? = 0 ] ; then
		echo "Integrated Lights-Out Configuration Report saved to ${ILO_FILE##/tmp/*/}"
		echo " - this is not a RIBCL configuration script"
	else
		echo "Failed to save iLO configuration to ${ILO_FILE##/tmp/*/}"
	fi
fi

# Copy the log files if any and unmount the key
ssstk_stop
