#!/bin/bash
# 
# This script applies firmware updates.
# The binaries are located on the USB key in "fw" directory
#
# October 2011

clear
echo "*** Apply Firmware Updates ***"

[ -f /ssstk/ssstk-functions ] && . /ssstk/ssstk-functions

# Load the drivers and mount the USB key where the settings will be saved
ssstk_init

echo "Starting Firmware Upgrade..."

for f in "${TMPDIR}/fw_files/"*.scexe; do
	chmod 755 $f
	$f -s
	if [ $? -eq 0 ] ; then
		echo "Firmware $f APPLIED"
	else
		echo "Firmware $f NOT applied"
	fi
done

# Copy the log files if any and unmount the key
ssstk_stop
