#!/bin/bash
#
# This script deploys the HP ProLiant BIOS, Smart Array RAID controllers and
# iLO configurations previously captured on an HP ProLiant server to another
# HP ProLiant server.
# Some iLO configuration settings (IP, Administrator's password) can be 
# customized through a file (config/ilo) on the USB key.
#
# October 2011

clear
echo "*** Deploying Configuration ***"

[ -f /ssstk/ssstk-functions ] && . /ssstk/ssstk-functions

# Load the drivers and mount the USB key where the settings will be saved
ssstk_init

# Deploy ProLiant BIOS configuration
dos2unix ${BIOS_FILE}

hp-conrep -l -f${BIOS_FILE} -x ${CONREP_XML}
if [ $? = 0 ] ; then
	echo "System Configuration data_files/conrep.dat APPLIED"
else
	echo "System Configuration data_files/conrep.dat FAILED"
fi

# Check if a Smart Array controler is installed and deploy the configuration
$IFHW_CMD ${HWDISC_FILE} "$ALLBOARDS" "PCI:Smart Array" 2> /dev/null
if [ $? = 0 ] ; then
	dos2unix ${RAID_FILE}
	hpacuscripting -reset -i ${RAID_FILE}
	if [ $? = 0 ] ; then
		echo "Array Configuration data_files/cpqacuxe.dat APPLIED"
	else
		echo "Array Configuration data_files/cpqacuxe.dat FAILED"
	fi
else
	echo "No Smart Array detected, no ACU Configuration applied."
fi

# Check if an iLO interface is present and deploy its configuration
$IFHW_CMD ${HWDISC_FILE} "$ALLBOARDS" "PCI:Integrated Lights-Out" 2> /dev/null
if [ $? = 0 ] ; then
	modprobe hpilo
	# Source the customization file
	[ -f ${ILO_CONFIG_FILE} ] && dos2unix ${ILO_CONFIG_FILE} && . ${ILO_CONFIG_FILE}
	[ "x$ILO_IP" != "x" ] && OPTS="--ip $ILO_IP"
	[ "x$ILO_NETMASK" != "x" ] && OPTS="$OPTS --netmask $ILO_NETMASK"
	[ "x$ILO_GW" != "x" ] && OPTS="$OPTS --gw $ILO_GW"
	[ "x$ILO_LICENSE" != "x" ] && OPTS="$OPTS --license $ILO_LICENSE"
	[ "x$ILO_ADMIN_PASSWD" != "x" ] && OPTS="$OPTS --password $ILO_ADMIN_PASSWD"
	# Do the cleanup and customization of the iLO config file
	dos2unix ${ILO_FILE} 
	etreeiloclean.py $OPTS $ILO_FILE > ${ILO_UPDATED_FILE}
	if [ -f ${ILO_UPDATED_FILE} ]; then
		hponcfg -f ${ILO_UPDATED_FILE} 
		if [ $? = 0 ] ; then
			echo "Integrated Lights-Out Configuration ${ILO_UPDATED_FILE} APPLIED"
		else
			echo "Integrated Lights-Out Configuration ${ILO_UPDATED_FILE} FAILED"
		fi
	else
		echo "Integrated Lights-Out Configuration filtering of hponcfg.dat FAILED"
	fi
fi

# Copy the log files if any and unmount the key
ssstk_stop
