#!/bin/bash
# 
# This script deploys a very minimal and basic iLO configuration.
# The XML config file is on the USB key (data_files/ilo.dat) and is applied as
# it is, no substitution or customization done by any script.
#
# October 2011

clear
echo "*** Deploying iLO Configuration only ***"

[ -f /ssstk/ssstk-functions ] && . /ssstk/ssstk-functions

# Load the drivers and mount the USB key where the settings will be saved
ssstk_init

# Check if an iLO interface is present and deploy its configuration
$IFHW_CMD ${HWDISC_FILE} "$ALLBOARDS" "PCI:Integrated Lights-Out" 2> /dev/null
if [ $? = 0 ] ; then
	modprobe hpilo
	if [ -f ${ILO_MINIMAL_FILE} ]; then
		hponcfg -f ${ILO_MINIMAL_FILE} 
		if [ $? = 0 ] ; then
			echo "Integrated Lights-Out Minimal Configuration APPLIED"
		else
			echo "Integrated Lights-Out Minimal Configuration FAILED"
		fi
	else
		echo "Cannot find $ILO_MINIMAL_FILE"
	fi
fi

# Copy the log files if any and unmount the key
ssstk_stop
