#!/bin/bash

DISK_LABEL="LiveUSB"

clear
echo "*** Apply Firmware Updates ***"

HWDISC_FILE=/tmp/hpdiscovery.xml
export TMPDIR=$(mktemp -t -d liveusb.XXXXXX)
mount -t vfat /dev/disk/by-label/${DISK_LABEL} $TMPDIR

echo ""
echo "Loading storage drivers for hardware"
./load_modules.sh

echo ""
echo "Pausing to allow drivers to finish loading"
sleep 15
echo ""

## rerun hardware discovery 
./hpdiscovery -f ${HWDISC_FILE}
echo "Hardware Discovery saved to ${HWDISC_FILE}"

## use hwquery to fetch the SystemName from hardware discovery file. ( extra " " are required ) 
export "`./hwquery ${HWDISC_FILE} allboards.xml SERVERTYPE=SystemName`";

echo "Server Type: ${SERVERTYPE}"
echo "Starting Firmware Upgrade..."

for f in "${TMPDIR}/fw_files/"*.scexe; do
	chmod 755 $f
	$f -s
	if [ $? -eq 0 ] ; then
		echo "Firmware $f APPLIED"
	else
		echo "Firmware $f NOT applied"
	fi
done
./stop.sh
