use 5.006001;
use ExtUtils::MakeMaker;
use strict;

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
	NAME         => 'PBPKG',
	DISTNAME     => 'PBPKG',
	VERSION      => 'PBVER',
	INST_SCRIPT  => 'blib/bin',
	INSTALLDIRS  => 'perl',
	PREREQ_PM    => {
			#HTTP::Headers                    => 1.59,
			#Template                         => 0,
	},    # e.g., Module::Name => 1.1
	#ABSTRACT_FROM => 'bin/cb',   # retrieve abstract from module
	AUTHOR        => 'Bruno Cornec <bruno#project-builder.org>',
	EXE_FILES     => [ qw( bin/cbusterize bin/cb ) ],
	MAN1PODS      => { 
			'bin/cbusterize' => '$(INST_MAN1DIR)/cbusterize.$(MAN1EXT)', 
			'bin/cb' => '$(INST_MAN1DIR)/cb.$(MAN1EXT)', 
	},
	MAN3PODS      => {	'lib/CasparBuster/Env.pm' => '$(INST_MAN3DIR)/CasparBuster::Env.$(MAN3EXT)',
						#'lib/ProjectBuilder/Base.pm' => '$(INST_MAN3DIR)/ProjectBuilder::Base.$(MAN3EXT)', 
					},
);

package MY;

sub postamble {

	# Determine location of etc conf files
	my $text ="";

	# Grab out any CONFDIR or MANDIR param
	my $confdir = undef;
	my $mandir = undef;

	while (my $arg = shift @ARGV) {
		my ($key, $value) = split /=/, $arg;
		if ($key =~ /^CONFDIR$/) {
			$confdir = $value;
		} elsif ($key =~ /^MANDIR$/) {
			$mandir = $value;
		}
	}

	my $etcdir = $confdir || "/usr/local/etc/cb";
	my $mandir = $mandir || "/usr/local/share/man";

	# Use that conf dir info to modify Distribution.pm
	system("perl -pi -e \"s~CCCC~$etcdir~\" lib/CasparBuster/Env.pm");

	$text .= "install ::\n";
	$text .= "\t".'mkdir -p $(DESTDIR)'."$etcdir\n";
	$text .= "\t".'chmod 755 $(DESTDIR)'."$etcdir\n";
	$text .= "\t".'cp etc/cb/cb.conf $(DESTDIR)'."$etcdir\n";

	# Produce the man page for pb.conf
	$text .= "\t".'mkdir -p $(DESTDIR)'."$mandir/man5\n";
	$text .= "\t".'pod2man --section=5 etc/cb/cb.conf > $(DESTDIR)'."$mandir/man5/cb.conf.5\n";
	return($text);
}
