#
# Creates common environment for distributions
#
# $Id$
#
#
package CasparBuster::Env;

use strict;

# Global vars
# Inherit from the "Exporter" module which handles exporting functions.
#
use vars qw($VERSION $REVISION @ISA @EXPORT);
use Exporter;
#
# Export, by default, all the functions into the namespace of
# any code which uses this module.

our @ISA = qw(Exporter);
our @EXPORT = qw(cb_env_conffile);

=pod

=head1 NAME

CasparBuster::Env - module dealing with CasparBuster environment

=head1 DESCRIPTION

This modules provides functions to allow the setup of the CasparBuster environment

=head1 SYNOPSIS

  use CasparBuster::Env;
  my $conffile = cb_env_conffile();

=head1 USAGE

=over 4

=item B<cb_env_conffile>

This function returns the mandatory configuration file used for CasparBuster

=cut

sub cb_env_conffile {
		return("CCCC/cb.conf");
}
