#
# Manages Plugins for CasparBuster
#
# $Id$
#
#
package CasparBuster::Plugin;

use strict;
use warnings;
use CasparBuster::Env;
use ProjectBuilder::Base;
use ProjectBuilder::Conf;
use Data::Dumper;

# Global vars
# Inherit from the "Exporter" module which handles exporting functions.
#
use vars qw($VERSION $REVISION @ISA @EXPORT);
use Exporter;
#
# Export, by default, all the functions into the namespace of
# any code which uses this module.

our @ISA = qw(Exporter);
our @EXPORT = qw(cb_plugin_load cb_plugin_get);

=pod

=head1 NAME

CasparBuster::Plugin - module dealing with CasparBuster plugin management

=head1 DESCRIPTION

This modules provides functions to allow the management of CasparBuster plugins

=head1 SYNOPSIS

  use CasparBuster::Plugin;

=head1 USAGE

=over 4

=item B<cb_plugin_load>

This function loads all the plugins defined for this CasparBuster environement

=cut

sub cb_plugin_load {

my ($pluginsdir) = pb_conf_get("cbpluginssubdir");
my $cbconfdir = cb_env_confdir()."/$pluginsdir->{$ENV{'PBPROJ'}}";
opendir(DIR,$cbconfdir) || die "Unable to open $cbconfdir: $!";
foreach my $f (readdir(DIR)) {
	next if ($f =~ /^\./);
	# Add on plugins files
	if ($f =~ /\.conf$/) {
		pb_conf_add("$cbconfdir/$f") if (-f "$cbconfdir/$f");
	}
}
closedir(DIR);
}


=item B<cb_plugin_get>

This function adds into the plugin hash, passed as second parameter, the new plugin content based on its name, passed as first parameter.

=cut

sub cb_plugin_get {

my $plugin = shift;
my $cbp = shift;

pb_log(2,"Entering cb_plugin_get for plugin $plugin\n");
my ($flist,$dlist,$dflist,$slist) = pb_conf_get_if("cbpluginfiles","cbplugindirs","cbplugindirsandfiles","cbpluginreload");
if ((defined $flist) && (defined $flist->{$plugin}) && ($flist->{$plugin} !~ /^\s*$/)) {
	foreach my $block (split(/;/,$flist->{$plugin})) {
		pb_log(3,"block : $block\n");
		my ($name,$tmp) = split(/\|/,$block);
		($cbp->{$plugin}->{'files'}->{$name}->{'uid'},$cbp->{$plugin}->{'files'}->{$name}->{'gid'},$cbp->{$plugin}->{'files'}->{$name}->{'mode'}) = split(/\,/,$tmp);
	}
}
if ((defined $dlist) && (defined $dlist->{$plugin}) && ($dlist->{$plugin} !~ /^\s*$/)) {
	foreach my $block (split(/;/,$dlist->{$plugin})) {
		pb_log(3,"block : $block\n");
		my ($name,$tmp) = split(/\|/,$block);
		($cbp->{$plugin}->{'dirs'}->{$name}->{'uid'},$cbp->{$plugin}->{'dirs'}->{$name}->{'gid'},$cbp->{$plugin}->{'dirs'}->{$name}->{'mode'}) = split(/\,/,$tmp);
	}
}
if ((defined $dflist) && (defined $dflist->{$plugin}) && ($dflist->{$plugin} !~ /^\s*$/)) {
	foreach my $block (split(/;/,$dflist->{$plugin})) {
		pb_log(3,"block : $block\n");
		my ($name,$tmp) = split(/\|/,$block);
		($cbp->{$plugin}->{'dirsandfiles'}->{$name}->{'uid'},$cbp->{$plugin}->{'dirsandfiles'}->{$name}->{'gid'},$cbp->{$plugin}->{'dirsandfiles'}->{$name}->{'mode'}) = split(/\,/,$tmp);
	}
}
if ((defined $slist) && (defined $slist->{$plugin})) {
	$cbp->{$plugin}->{'reloadscript'} = $slist->{$plugin};
}
pb_log(2,"cbp: ".Dumper($cbp)."\n");
return($cbp);
}

1;
