#!/usr/bin/perl -w
#
# Project Builder configuration file
# For project pb ;-)
#
# $Id$
#
use strict;
use Exporter();
use vars qw(@ISA @EXPORT_OK);
@ISA = qw(Exporter);
# global vars are here
@EXPORT_OK = qw(%defpkgdir %extpkgdir %version %param %filteredfiles &pb_init);
use vars @EXPORT_OK;
use AppConfig qw(ARGCOUNT_HASH);

sub pb_init {

my $conffile = shift;
my $ptr;

my $config = AppConfig->new({
							# Auto Create variables mentioned in Conf file
							CREATE => 1,
							DEBUG => 0,
							GLOBAL => {
								# Each conf item is a hash
								ARGCOUNT => AppConfig::ARGCOUNT_HASH
							}
						});
$config->file($conffile);

# Root of the project to build
# needs at least 2 levels of dir as in the upper 
# other dirs will be created and used
$ptr = $config->get("param");
%param = %$ptr;

# List of pkg to build by default
$ptr = $config->get("defpkgdir") || die "Unable to find defpkgdir in $conffile";
%defpkgdir = %$ptr;

# List of additional pkg to build when all is called
$ptr = $config->get("extpkgdir");
%extpkgdir = %$ptr;

# Valid version names
$ptr = $config->get("version");
%version = %$ptr;

# List of files to filter
$ptr = $config->get("filteredfiles");
%filteredfiles = %$ptr;

}
1;
