#!/usr/bin/perl -w

#
# HyPer-Linux perl script 
# ======================
# The script is a cgi-bin script allowing the automatic configuration 
# of HP ProLiant through a Web Browser, for preloaded Linux distribution
# customization.
#
# This program is free software and is made available under the GPLv2.
# (c) 2013 B. Cornec - Hewlett-Packard
#

use strict;
use CGI;
use CGI::Carp qw(fatalsToBrowser);

my $distrib = "RH64";
my $infofile = "/usr/share/lib/locale";

my $cgi = new CGI;

my $name;
my $s;
my $ftp;
my $shortname;
my $sysfont;
my $unused;
my %lang;
my %keyboard;
my %timezone;
my @lang;
my @keyboard;
my @timezone;
my $lang;
my $keyboard;
my $timezone;

open(INFO,$infofile) || die "Unable to open $infofile";
while (<INFO>) {
	s/		/	/g;
	($name, $shortname, $sysfont, $unused, $lang, $keyboard, $timezone) = split(/	/);
	chomp($timezone);
	$name =~ s/ //g;
	$timezone =~ s/ //g;
	$keyboard =~ s/ //g;
	$lang =~ s/ //g;
	$lang{$lang} = "$name"." ($lang)";
	push(@lang, ($lang));
	$keyboard{$keyboard} = "$name"." ($keyboard)";
	push(@keyboard, ($keyboard));
	$timezone{$timezone} = "$name"." ($timezone)";
	push(@timezone, ($timezone));
	}

print $cgi->header;
print $cgi->start_html('HyPer-Linux Configuration');
print $cgi->h1('HyPer-Linux Configuration');
print $cgi->hr;
print << EOF;
<TABLE WIDTH="100%" >
<TR>
	<TD rowspan=2><IMG SRC="hp.gif" HEIGHT=66 WIDTH=66 ALIGN=LEFT> </TD>
	<TD> <FONT SIZE=+3> RedHat Enterprise Linux Installation Server </FONT> </TD>
</TR>
<TR>
	<TD align=right></TD>
</TR>
</TABLE>


if (not ($cgi->param())) {
print $cgi->start_form;
print $cgi->h2('Configuration of the localization');
print "Language : ",$cgi->popup_menu(-name=>'language',
			-values=>\@lang,
			-default=>'fr_FR',
			-labels=>\%lang);
print "<P>\n";
print "Keyboard : ",$cgi->popup_menu(-name=>'keyboard',
			-values=>\@keyboard,
			-default=>'fr',
			-labels=>\%keyboard);
print "<P>\n";
print "Timezone : ",$cgi->popup_menu(-name=>'timezone',
			-values=>\@timezone,
			-default=>'Europe/Paris',
			-labels=>\%timezone);
print "<P>\n";
print $cgi->hr;

my %labels = ('MySQL' => 'MySQL Server',
		'PGSQL' => 'PostgreSQL Server',
		'EDB' => 'EnterpriseDB Server');
print $cgi->h2('Configuration of the services');
print "Which services do you want to activate by default at boot time : <P>\n",$cgi->popup_menu(-name=>'services',
			-values=>['MySQL','PGSQL','EDB'],
			-defaults=>['PGSQL'],
			-labels=>\%labels);
print $cgi->hr;
print $cgi->h2('Configuration of the network parameters');
%labels = ('DHCP' => 'Configuration through a DHCP server',
		'STATIC' => 'Static IP configuration');
print "Mode : ",$cgi->popup_menu(-name=>'mode',
			-values=>['DHCP','STATIC'],
			-default=>'DHCP',
			-labels=>\%labels);
print "<P>\n";
print "If you choose just above the Static IP configuration mode, please fill the following fields :<P>\n";
print "Full Qualified Domain Name of the system : ",$cgi->textfield(-name=>'name',
				-default=>'netserver',
				-size=>15,
				-maxlenght=>15);
print "<P>IP address : ",$cgi->textfield(-name=>'address',
				-default=>'192.168.1.1',
				-size=>15,
				-maxlenght=>15);
print "     Netmask     : ",$cgi->textfield(-name=>'netmask',
				-default=>'255.255.255.0',
				-size=>15,
				-maxlenght=>15);
print "<P>Gateway    : ",$cgi->textfield(-name=>'gateway',
				-default=>'192.168.1.254',
				-size=>15,
				-maxlenght=>15);
print "     Primary DNS : ",$cgi->textfield(-name=>'dns',
				-default=>'192.168.1.100',
				-size=>15,
				-maxlenght=>15);
print "<P>\n";
print $cgi->submit;
print $cgi->end_form;
}
 
else {
	print $cgi->h2('You made the following choices :');
	print $cgi->hr;
	print "<BOLD>Localisation </BOLD> - ";
	print "Language : <em>",$cgi->param('language'),", </em>";
	print "Keyboard : <em>",$cgi->param('keyboard'),", </em>";
	print "Timezone : <em>",$cgi->param('timezone'),"</em>";
	print $cgi->hr;
	print "<BOLD>Network</BOLD> configuration mode ";
	if ($cgi->param('mode') eq 'STATIC') {
		print "<em>static</em><P>"; 
		print "Name : <em>",$cgi->param('name'),"</em><P>";
		print "IP address : <em>",$cgi->param('address'),", </em>";
		print "Netmask : <em>",$cgi->param('netmask'),"</em><P>";
		print "Gateway : <em>",$cgi->param('gateway'),", </em>";
		print "DNS server : <em>",$cgi->param('dns'),", </em>";
	}
	else {
		print "<em>dynamic (DHCP)</em>" 
	}
	print $cgi->hr;
	print "<BOLD>Services</BOLD> activated at boot time : ";
	foreach $s ($cgi->param('services')) {
		print "- <em>MySQL server</em> -" if ( $s =~ /MySQL/);
		print "- <em>PostgreSQL server</em> -" if ($s =~ /PGSQL/);
		print "- <em>EnterpriseDB server</em> -" if ($s =~ /EDB/);
	}
	print $cgi->hr;
	print "Your customization parameters are now being commited to the server which will then reboot to ensure a proper environement.<P>";
	print "Please wait till it's done ...";
	print $cgi->end_form;

	#
	# Now doing the job ...
	#
	my $gendir = "/var/hyperlinux";
	my $gensys = "$gendir/sysconfig";
	my $gennet = "$gendir/network";
	my $genbin = "$gendir/bin";
	mkdir $gendir,0700;
	mkdir $gensys,0700;
	mkdir $gennet,0700;
	mkdir $genbin,0700;

	if ($distrib eq "RH70") {
		#
		# Localisation
		#
		open(T,"> $gensys/clock") || die "Unable to open $gensys/clock";
		print T 'ZONE="',$cgi->param('timezone'),'"',"\n";
		#print T "UTC=false\n";
		#print T "ARC=false\n";
		close(T);
		open(T,"> $gensys/keyboard") || die "Unable to open $gensys/keyboard";
		print T 'KEYBOARDTYPE="pc"',"\n";
		print T 'KEYTABLE="',$cgi->param('keyboard'),'"',"\n";
		close(T);
		open(T,"> $gensys/i18n") || die "Unable to open $gensys/i18n";
		print T 'LANG="',$cgi->param('language'),'"',"\n";
		close(T);
		#
		# Network
		#
		open(T,"> $gensys/network") || die "Unable to open $gensys/network";
		print T 'NETWORKING="yes"',"\n";
		print T 'GATEWAYDEV="eth0"',"\n";
		print T 'GATEWAY="',$cgi->param('gateway'),'"',"\n";
		print T 'HOSTNAME="',$cgi->param('name'),'"',"\n";
		close(T);
		open(T,"> $gennet/ifcfg-eth0") || die "Unable to open $gennet/ifcfg-eth0";
		print T "DEVICE=eth0\n";
		print T "USERCTL=no\n";
		print T "ONBOOT=yes\n";
		if ($cgi->param('mode') eq 'DHCP') {
			print T "BOOTPROTO=dhcp\n";
			print T "IPADDR=\n";
			print T "NETMASK=\n";
			print T "NETWORK=\n";
			print T "BROADCAST=\n";
		}
		else {
			print T "BOOTPROTO=none\n";
			print T 'IPADDR="',$cgi->param('address'),'"',"\n";
			print T 'NETMASK="',$cgi->param('netmask'),'"',"\n";
			print T "NETWORK=\n";
			print T "BROADCAST=\n";
		}
		close(T);
		#
		# Services
		#
		open(T,"> $genbin/populate") || die "Unable to open $genbin/populate";
		print T "#!/bin/sh\n";
		print T "#\n";

		$ftp = 0;
		foreach $s ($cgi->param('services')) {
			print T "/sbin/chkconfig --level 345 mysqld on\n" if ($s =~ /MySQL/);
			print T "/sbin/chkconfig --level 345 postgresql on\n" if ($s =~ /PGSQL/);
			print T "/sbin/chkconfig --level 345 EDB on\n" if ($s =~ /EDB/);
		}
		print T "/bin/mv $gensys/* /etc/sysconfig\n";
		print T "/bin/mv $gennet/* /etc/sysconfig/network-scripts\n";
		print T "/sbin/shutdown -r +1 'Reboot for HyPer-Linux Configuration...'\n";
		close(T);
		chmod 0755,"$genbin/populate";
		system("sudo $genbin/populate");
	}
}
