#!/usr/bin/perl -w
#
# Creates common environment for distributions
#
# $Id$
#

use strict;

sub distro_init {

my $ddir = shift;
my $dver = shift;
my $dfam = "unknown";
my $dtype = "unknown";
my $dsuf = "unknown";

# If we don't know which distribution we're on, then guess it
($ddir, $dver) = distro_get() if ((not defined $ddir) || (not defined $dver));

# There shold be unicity of names between ddir dfam and dtype
# In case of duplicate, bad things can happen
if (($ddir =~ /debian/) ||
	($ddir =~ /ubuntu/)) {
	$dfam="du";
	$dtype="deb";
	$dsuf=".$ddir$dver";
} elsif ($ddir =~ /gentoo/) {
	$dfam="gen";
	$dtype="ebuild";
	my $dver1 = $dver;
	$dver1 =~ s/\.//;
	$dsuf=".$ddir$dver1";
} elsif ($ddir =~ /slackware/) {
	$dfam="slack";
	$dtype="tgz";
	$dsuf=".$dfam$dver";
} elsif (($ddir =~ /suse/) ||
		($ddir =~ /sles/)) {
	$dfam="novell";
	$dtype="rpm";
	$dsuf=".$ddir$dver";
} elsif (($ddir =~ /redhat/) ||
		($ddir =~ /rhel/) ||
		($ddir =~ /fedora/) ||
		($ddir =~ /centos/)) {
	$dfam="rh";
	$dtype="rpm";
	my $dver1 = $dver;
	$dver1 =~ s/\.//;
	if ($ddir =~ /fedora/) {
		$dsuf=".fc$dver1";
	} elsif ($ddir =~ /redhat/) {
		$dsuf=".rh$dver1";
	} else {
		$dsuf=".$ddir$dver1";
	}
} elsif (($ddir =~ /mandrake/) ||
		($ddir =~ /mandriva/)) {
	$dfam="md";
	$dtype="rpm";
	if ($ddir =~ /mandrake/) {
		my $dver1 = $dver;
		$dver1 =~ s/\.//;
		$dsuf=".mdk$dver1";
	} else {
		$dsuf=".mdv$dver";
	}
} elsif ($ddir =~ /freebsd/) {
	$dfam="bsd";
	$dtype="port";
	my $dver1 = $dver;
	$dver1 =~ s/\.//;
	$dsuf=".$dfam$dver1";
} else {
	$dfam="unknown";
	$dtype="unknown";
	$dsuf="unknown";
}

return($ddir, $dver, $dfam, $dtype, $dsuf);
}

sub distro_get {
}
1;
