#!/usr/bin/perl -w
#
# Project Builder configuration file handler
# For project pb ;-)
#
# $Id$
#
use strict;
use AppConfig qw(ARGCOUNT_HASH);

sub pb_init {

my $conffile = shift;
my $ptr;

my $config = AppConfig->new({
							# Auto Create variables mentioned in Conf file
							CREATE => 1,
							DEBUG => 0,
							GLOBAL => {
								# Each conf item is a hash
								ARGCOUNT => AppConfig::ARGCOUNT_HASH
							}
						});
$config->file($conffile);

# Root of the project to build
# needs at least 2 levels of dir as in the upper 
# other dirs will be created and used 

# main parameter hash (mandatory)
$ptr = $config->get("confparam") || die "Unable to find confparam in $conffile";
%confparam = %$ptr;

# List of pkg to build by default (mandatory)
$ptr = $config->get("defpkgdir") || die "Unable to find defpkgdir in $conffile";
%defpkgdir = %$ptr;

# List of additional pkg to build when all is called (optional)
$ptr = $config->get("extpkgdir");
if (not defined $ptr) {
	%extpkgdir = ();
} else {
	%extpkgdir = %$ptr;
}

# Valid version names (optional)
$ptr = $config->get("version");
if (not defined $ptr) {
	%version = ();
} else {
	%version = %$ptr;
}

# List of files to filter (optional)
$ptr = $config->get("filteredfiles");
if (not defined $ptr) {
	%filteredfiles = ();
} else {
	%filteredfiles = %$ptr;
}

}
1;
