#!/usr/bin/perl -w
#
# Tests ProjectBuilder::Base functions

use strict;
use ProjectBuilder::Base;
use ProjectBuilder::Conf;

eval
{
	require Test::More;
	Test::More->import();
	my ($tmv,$tmsv) = split(/\./,$Test::More::VERSION);
	if ($tmsv lt 87) {
		die "Test::More is not available in an appropriate version ($tmsv)";
	}
};

# Test::More appropriate version not found so no test will be performed here
if ($@) {
	require Test;
	Test->import();
	plan(tests => 1);
	print "# Faking tests as Test::More is not available in an appropriate version\n";
	ok(1,1);
	exit(0);
}

my $nt = 0;
	is($path, $test->{$uri}[4], "pb_get_uri Test path $uri");
	$nt++;
}

$ENV{'TMPDIR'} = "/tmp";
pb_temp_init();

pb_conf_init("test");
my $cf = pb_distro_conffile();
my $cnt = pb_get_content($cf);

my %h = pb_conf_cache($cf,\%h);
pb_conf_write("$PBTMP/test.pb",\%h);
my $content = pb_get_content("$PBTMP/test.pb");
is($cnt, $content, "pb_conf_write Test");
$nt++;

done_testing($nt);
