#!/usr/bin/perl -w
#
# Creates build environment and files for packages creation from CMS repository
#
# $Id$
#

use strict;
use common.pm;
use proj.pm;
use cms.pm;

set_env();

VER=`cat ${TOOLHOME}/VERSION`
TAG=`cat ${TOOLHOME}/TAG`
DEST=${TOPDIR}/${VER}-$TAG
TEST="false"
OPT=""
mkdir -p $DEST

if [ "$1" = "--test" ]; then
	TEST="true"
	#OPT="-r BASE"
	shift
fi	

if [ "$1" = "" ]; then
	c="$DEFPKG[*]"
else
	if [ "$1" = "all" ]; then
			c="$ALLPKG[*]"
	else
		c="$*"
	fi
fi

# Make it safe for CMS commands
cd ${TOOLHOME}/..

for pkg in $c; do
	p=$PKGDIR[
	v=`cat ${TOOLHOME}/../$p/VERSION`
	tag=`cat ${TOOLHOME}/../$p/TAG`
	echo "Management of $p $v-$tag (rev $REVISION)"
	dest="$DEST/$p-$v"
	rm -fr $dest
	$CMSEXP $OPT ${TOOLHOME}/../$p $dest
	echo "$REVISION" > $dest/REVISION
	echo "Generating SVN log file ..."
	$SVNLOG $OPT -v ${TOOLHOME}/../$p > $dest/history.log

	for d in `cat ${TOOLHOME}/DISTROS`; do
		export ddir=`echo $d | cut -d_ -f1`
		export dver=`echo $d | cut -d_ -f2`
		echo "Generating build files for $ddir ($dver)"
		. $TOOLHOME/distro-env

		ddd=`LANG=C ; date '+%Y-%m-%d'`
		cat > $PROJTMP/mondorescue.mc << EOF
define(\`TTT', ${tag})dnl
define(\`RRR', ${tag}${suf})dnl
define(\`VVV', ${v})dnl
define(\`DDD', ${ddd})dnl
EOF

		mkdir -p $dest/distributions/$ddir $dest/distributions/${ddir}-$dver
		if [ "$dtype" = "rpm" ]; then
			if [ -f $dest/distributions/$ddir/spec.m4 ]; then
				inc=$dest/distributions/$ddir/spec.m4
			elif [ -f $dest/distributions/$dfam/spec.m4 ]; then
				inc=$dest/distributions/$dfam/spec.m4
			else
				echo "Unable to build the RPM specfile for this distro. Please report to authors"
				exit -1
			fi

			if [ $ddir = "fedora" ]; then
				$TOOLHOME/mkchangelog.pl fc $p $PROJTMP/$p-fc.spec
				m4 $PROJTMP/mondorescue.mc $inc $dest/distributions/rpm/$p.spec $MONDOTMP/$p-fc.spec > $dest/distributions/${ddir}-$dver/$p-fc.spec
			fi
			$TOOLHOME/mkchangelog.pl $dtype $p $PROJTMP/$p.spec
			if [ $? -ne 0 ]; then
				echo "Unable to create changelog for ${ddir}-$dver/$p.spec"
				exit -1
			fi
			m4 $PROJTMP/mondorescue.mc $inc $dest/distributions/rpm/$p.spec $MONDOTMP/$p.spec > $dest/distributions/${ddir}-$dver/$p.spec
			if [ _"`/bin/arch`" = _"x86_64" ] && [ $ddir = "rhel" ]; then
				# Bug on x86_64 on _sysconfdir on rhel4 at least
				perl -pi -e 's~^export CONFDIR=.*~export CONFDIR=/etc~' $dest/distributions/${ddir}-$dver/$p.spec
			fi

			rm -f $PROJTMP/$p.spec
		elif [ "$dtype" = "ebuild" ]; then
			m4 $PROJTMP/mondorescue.mc $dest/distributions/$dfam/$p.ebuild > $dest/distributions/${ddir}-$dver/$p-$v.ebuild
		elif [ "$dtype" = "tgz" ]; then
			m4 $PROJTMP/mondorescue.mc $dest/distributions/$dfam/slack-desc > $dest/distributions/${ddir}-$dver/slack-desc
		elif [ "$dtype" = "port" ]; then
			m4 $PROJTMP/mondorescue.mc $dest/distributions/$dfam/Makefile > $dest/distributions/${ddir}-$dver/Makefile
		elif [ "$dtype" = "deb" ]; then
			if [ -f $dest/distributions/$ddir/rules ]; then
				cp -a $dest/distributions/$ddir/* $dest/distributions/${ddir}-$dver
				inc=$dest/distributions/$ddir/rules
			elif [ -f $dest/distributions/$dfam/rules ]; then
				cp -a $dest/distributions/$dfam/* $dest/distributions/${ddir}-$dver
				inc=$dest/distributions/$dfam/rules
			else
				echo "Unable to build the .deb build files for this distro. Please report to authors"
				exit -1
			fi
			m4 $PROJTMP/mondorescue.mc $inc > $dest/distributions/${ddir}-$dver/rules
			$TOOLHOME/mkchangelog.pl $dtype $p $dest/distributions/${ddir}-$dver/changelog
			if [ $? -ne 0 ]; then
				echo "Unable to create changelog for ${ddir}-$dver/changelog"
				exit -1
			fi
		else
			echo "Unknown Build"
		fi
	done

	# The rest is done there
	cd $DEST
	if [ _"`echo $p | grep mondo-doc`" != _"" ]; then
		cd $dest
		for f in mondorescue-howto.sgml *8; do
			m4 $PROJTMP/mondorescue.mc $f > ${f}.new
			mv ${f}.new $f
		done
		make -f Makefile.howto
		if [ $? != 0 ]; then
			exit -1
		fi
		make -f Makefile.man
		if [ $? != 0 ]; then
			exit -1
		fi
		cd ..
	fi
	if [ _"`echo $p | grep 'busybox'`" != _"" ]; then
		cd $dest
		mv Rules.mak Rules.mak.orig
		cat Rules.mak.orig | sed "s/^EXTRAVERSION\([\t ]*\):=/EXTRAVERSION\1:=-$tag-r$REVISION/" > Rules.mak
		cd ..
	fi

	if [ _"`echo $p | grep -vE 'kernel|busybox' | grep mindi`" != _"" ]; then
		v1=`cat ${TOOLHOME}/../mondo-doc/VERSION`
		if [ ! -d mondo-doc-$v1 ]; then
			echo "mondo-doc should be created before $p"
			exit -1
		fi
		(cd mondo-doc-$v1 ; make -f Makefile.man install-$p INSTALLDIR=../$p-$v)
		rm -f $dest/rootfs/sbin/parted2fdisk-ia64 
	fi
	if [ "`echo $p | grep -v doc | grep  mondo`" != "" ]; then
		v1=`cat ${TOOLHOME}/../mondo-doc/VERSION`
		if [ ! -d mondo-doc-$v1 ]; then
			echo "mondo-doc should be created before $p"
			exit -1
		fi
		(cd mondo-doc-$v1 ; make -f Makefile.howto install INSTALLDIR=../$p-$v/docs/en ; make -f Makefile.man install-$p INSTALLDIR=../$p-$v/docs/man)
		(cd $dest ; echo "Bootstraping mondo ... " ; ./bootstrap)
	fi

	# Finally creates the tar files
	echo -n "Creating $p tar files (gzip... "
	tar cfphz ${DEST}/$p-$v.tar.gz $p-$v
	if [ $TEST = "false" ]; then
		echo -n " bzip2..."
		tar cfphj ${DEST}/$p-$v.tar.bz2 $p-$v
	fi
	echo " )"
	if [ $TEST = "true" ]; then
		echo "Use source under $DEST/$p-$v"
	fi
done

rm -rf $PROJTMP

echo "Version delivered :"
echo "-------------------"
echo "${VER}-$TAG"
echo "-------------------"
echo "${VER}-$TAG" > ${TOPDIR}/LAST
exit 0
) 2>&1 | tee /tmp/cms2build.log
