module PB =
  autoload xfm
  
  let word    = Rx.word
  let ws      = Util.del_ws_tab
  let eol     = Util.eol
  let comment = Util.comment
  let empty   = Util.empty
  let eq      = del /[ \t]*=[ \t]*/ "="
  let comma   = del /[ \t]*,[ \t]*/ ","
  let sto_value = [ label "value" . store /[^ \t\n,]+/ ]

  let record = [ key word . ws . store word
                 . eq
                 . Build.opt_list sto_value comma
                 . (eol|comment)
                 ]

  let lns = ( record | comment | empty )*

  let xfm = transform lns (incl "/etc/toto")

