#!/usr/bin/perl -w
#
# Project Builder configuration file handler
# For project pb ;-)
#
# $Id$
#
use strict;
use AppConfig qw(ARGCOUNT_HASH);
use Data::Dumper;

sub pb_init {

my $conffile = shift;
my $ptr;
my $trace;

if ($debug > 0) {
	$trace = 1;
} else {
	$trace = 0;
}

my $config = AppConfig->new({
							# Auto Create variables mentioned in Conf file
							CREATE => 1,
							DEBUG => $trace,
							GLOBAL => {
								# Each conf item is a hash
								DEFAULT => { },
								ARGCOUNT => AppConfig::ARGCOUNT_HASH,
							}
						});
$config->file($conffile);

# Root of the project to build
# needs at least 2 levels of dir as in the upper 
# other dirs will be created and used 

# main parameter hash (mandatory)
$ptr = $config->get("confparam") || die "Unable to find confparam in $conffile";
%confparam = %$ptr;
print "DEBUG: confparam: ".Dumper($ptr)."\n" if ($debug >= 1);

# List of pkg to build by default (mandatory)
$ptr = $config->get("defpkgdir") || die "Unable to find defpkgdir in $conffile";
%defpkgdir = %$ptr;
print "DEBUG: defpkgdir: ".Dumper($ptr)."\n" if ($debug >= 1);

# List of additional pkg to build when all is called (optional)
$ptr = $config->get("extpkgdir");
print "DEBUG: extpkgdir1: ".Dumper($ptr)."\n" if ($debug >= 1);
if (not defined $ptr) {
	%extpkgdir = ();
} else {
	%extpkgdir = %$ptr;
}
print "DEBUG: extpkgdir: ".Dumper(\%extpkgdir)."\n" if ($debug >= 1);

# Valid version names (optional)
$ptr = $config->get("version");
if (not defined $ptr) {
	%version = ();
} else {
	%version = %$ptr;
}
print "DEBUG: version: ".Dumper(\%version)."\n" if ($debug >= 1);

# List of files to filter (optional)
$ptr = $config->get("filteredfiles");
if (not defined $ptr) {
	%filteredfiles = ();
} else {
	%filteredfiles = %$ptr;
}
print "DEBUG: filteredfiles: ".Dumper(\%filteredfiles)."\n" if ($debug >= 1);

}
1;
