package ProjectBuilder;
use Mojo::Base 'Mojolicious';

use ProjectBuilder::Model::Confs;

sub startup {
  my $self = shift;

  # Configuration
  #$self->secrets([split /:/, $ENV{'BLOG_SECRETS'} || 'super:s3cret']);

  # Model
  #$self->helper(pg => sub { state $pg = Mojo::Pg->new($ENV{'BLOG_PG_URL'}) });
  $self->helper(confs => sub { state $confs = ProjectBuilder::Model::Confs->new() });

  # Migrate to latest version if necessary
  #my $path = $self->home->rel_file('migrations/blog.sql');
  #$self->pg->migrations->name('blog')->from_file($path)->migrate;

  # Swagger API endpoints
  # /api             *       api
  #   +/confs        POST    "store"
  #   +/confs        GET     "list"
  #   +/confs/(:id)  PUT     "update"
  #   +/confs/(:id)  DELETE  "remove"
  #   +/confs/(:id)  GET     "show"
  $self->plugin(swagger2 => {url => $self->home->rel_file('api.json')});

  # Regular web pages
  # /                GET
  # /confs           GET     confs
  # /confs/create    GET     "create_conf"
  # /confs           POST    "store_conf"
  # /confs/:id       GET     "show_conf"
  # /confs/:id/edit  GET     "edit_conf"
  # /confs/:id       PUT     "update_conf"
  # /confs/:id       DELETE  "remove_conf"
  my $r = $self->routes;
  $r->get('/' => sub { shift->redirect_to('confs') });
  $r->get('/confs')->to('conf#list');
  $r->get('/confs/create')->to('conf#create')->name('create_conf');
  $r->post('/confs')->to('conf#store')->name('store_conf');
  $r->get('/confs/:id')->to('conf#show')->name('show_conf');
  $r->get('/confs/:id/edit')->to('conf#edit')->name('edit_conf');
  $r->put('/confs/:id')->to('conf#update')->name('update_conf');
  $r->delete('/conconfid')->to('conf#remove')->name('remove_conf');

  require Swagger2::Editor;
  my $editor = Swagger2::Editor->new(specification_file => $self->home->rel_file('api.json'));
  $r->route('/editor')->detour(app => $editor);
}

1;
