# (c) B.Cornec 2007-2016
# Eric Anderson's changes are (c) Copyright 2012 Hewlett Packard
# Provided under the GPL v2
use 5.006001;
use ExtUtils::MakeMaker;
use strict;

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
	NAME         => 'PBPKG',
	DISTNAME     => 'PBPKG',
	VERSION      => 'PBVER',
	INST_SCRIPT  => 'blib/bin',
	INSTALLDIRS  => 'perl',
	PREREQ_PM    => {
			#HTTP::Headers                    => 1.59,
			#Template                         => 0,
	},    # e.g., Module::Name => 1.1
	#ABSTRACT_FROM => 'bin/pb',   # retrieve abstract from module
	AUTHOR        => 'Bruno Cornec <bruno#project-builder.org>',
	EXE_FILES     => [ qw(bin/pbdistrocheck bin/pbgetparam) ],
	MAN1PODS      => { 
				'bin/pbdistrocheck' => '$(INST_MAN1DIR)/pbdistrocheck.$(MAN1EXT)', 
				'bin/pbgetparam' => '$(INST_MAN1DIR)/pbgetparam.$(MAN1EXT)', 
					},
#	MAN3PODS      => {	'lib/ProjectBuilder/Distribution.pm' => '$(INST_MAN3DIR)/ProjectBuilder::Distribution.$(MAN3EXT)',
						#'lib/ProjectBuilder/Conf.pm' => '$(INST_MAN3DIR)/ProjectBuilder::Conf.$(MAN3EXT)',
						#'lib/ProjectBuilder/Display.pm' => '$(INST_MAN3DIR)/ProjectBuilder::Display.$(MAN3EXT)',
						#'lib/ProjectBuilder/Log.pm' => '$(INST_MAN3DIR)/ProjectBuilder::Log.$(MAN3EXT)',
						#'lib/ProjectBuilder/Log/Item.pm' => '$(INST_MAN3DIR)/ProjectBuilder::Log::Item.$(MAN3EXT)',
						#'lib/ProjectBuilder/Base.pm' => '$(INST_MAN3DIR)/ProjectBuilder::Base.$(MAN3EXT)', },
);

package MY;

sub postamble {

	# Determine location of conf files
	my $text ="";

	# Grab out any SYSCONFDIR, CONFDIR or MANDIR param
	my $sharedir = undef;
	my $mandir = undef;
	my $sysconfdir = undef;
	my $prefix = undef;

	while (my $arg = shift @ARGV) {
		my ($key, $value) = split /=/, $arg;
		if ($key =~ /^CONFDIR$/) {
			$sharedir = $value;
		} elsif ($key =~ /^SYSCONFDIR$/) {
			$sysconfdir = $value;
		} elsif ($key =~ /^MANDIR$/) {
			$mandir = $value;
		} elsif ($key =~ /^PREFIX$/) {
			$prefix = $value;
		}
	}

	$sharedir ||= "$prefix/share/pb" if (defined $prefix);
	$mandir ||= "$prefix/share/man" if (defined $prefix);
	$sysconfdir ||= "$prefix/etc/pb" if (defined $prefix);
	$sharedir ||= "/usr/local/share/pb";
	$mandir ||= "/usr/local/share/man";
	$sysconfdir ||= "/etc/pb";

	# Use that conf dir info to modify Distribution.pm
	system("perl -pi -e \"s~CCCC~$sharedir~\" lib/ProjectBuilder/Distribution.pm");
	system("perl -pi -e \"s~SSSS~$sysconfdir~\" lib/ProjectBuilder/Distribution.pm");

	$text .= "install ::\n";
	$text .= "\t".'mkdir -p $(DESTDIR)'."$sharedir\n";
	$text .= "\t".'chmod 755 $(DESTDIR)'."$sharedir\n";
	$text .= "\t".'cp etc/pb.yml $(DESTDIR)'."$sharedir\n";
	$text .= "\t".'cp etc/api.yml $(DESTDIR)'."$sharedir\n";

	# Also create a fake version in /etc/pb for sysadmin to modify
	$text .= "\t".'mkdir -p $(DESTDIR)'."$sysconfdir\n";
	$text .= "\t".'chmod 755 $(DESTDIR)'."$sysconfdir\n";
	$text .= "\t".'perl -p -e \'s|^|#|\' etc/pb.yml > $(DESTDIR)/'."$sysconfdir/pb.yml\n";
	# Doesn't seem to work in the makefile generated for now :-(
	#$text .= "\t".'perl -p -e \'s|^([^#])|#$1|\' etc/pb.yml > $(DESTDIR)/'."$sysconfdir/pb.yml\n";

	# Produce the man page for pb.yml
	$text .= "\t".'mkdir -p $(DESTDIR)'."$mandir/man5\n";
	$text .= "\t".'pod2man --section=5 etc/pb.yml.pod > $(DESTDIR)'."$mandir/man5/pb.yml.5\n";
	return($text);
}
