#!/usr/bin/perl -w
#
# Creates changelog for packages from Changelog files in the apps
#
# $Id$
#

use strict;
use Date::Manip;
use File::Basename;
use English;
use ProjectBuilder::Base qw (pb_conf_get);

sub pb_changelog {

my $dtype = shift;
my $pkg = shift;
my $pbver = shift;
my $pbtag = shift;
my $dsuf = shift;
my $path = shift;
my $OUTPUT = shift;
my $doit = shift;

my $log = "";

# For date handling
$ENV{LANG}="C";

return("\n") if ((not (defined $dtype)) || ($dtype eq "") || 
		(not (defined $pkg)) || ($pkg eq "") || 
		(not (defined $pbver)) || ($pbver eq "") || 
		(not (defined $pbtag)) || ($pbtag eq "") || 
		(not (defined $dsuf)) || ($dsuf eq "") || 
		(not (defined $path)) || ($path eq "") || 
		(not (defined $OUTPUT)) || ($OUTPUT eq ""));
		(not (defined $doit)) || ($doit eq ""));

my $chglog = "$ENV{'PBROOT'}/$path/ChangeLog";
if ((! -f $chglog) && ($doit eq "yes")) {
	#print "No ChangeLog file ($chglog) for $pkg\n";
	return("\n");
}

# If we don't need to do it, fake something
if ($doit ne "yes") {
	my @date=(localtime->sec(), localtime->min(), localtime->hour(), localtime->mday(), localtime->mon(), localtime->year(), localtime->wday(), localtime->yday(), localtime->isdst());
	my $date = strftime("%Y-%m-%d", @date);
	my $ndate = UnixDate($date,"%a", "%b", "%d", "%Y");
	my $n2date = &UnixDate($date,"%a, %d %b %Y %H:%M:%S %z");
	if (($dtype eq "rpm") || ($dtype eq "fc")) {
		my $ver2 = "$pbver-$pbtag$dsuf";
		print $OUTPUT "* $ndate $packager->{$ENV{'PBPROJ'}} $ver2\n";
		print $OUTPUT "- Updated to $pbver\n";
		}
	if ($dtype eq "deb") {
		print $OUTPUT "$pkg ($pbver) unstable; urgency=low\n";
		print $OUTPUT "\n";
		print $OUTPUT " -- $packager->{$ENV{'PBPROJ'}}  $n2date\n\n\n";
		}
	return;
}

open(INPUT,"$chglog") || die "Unable to open $chglog (read)";

# Skip first 4 lines
my $tmp = <INPUT>;
$tmp = <INPUT>;
$tmp = <INPUT>;
if ($dtype eq "announce") {
	print $OUTPUT $tmp;
}
$tmp = <INPUT>;
if ($dtype eq "announce") {
	print $OUTPUT $tmp;
}

my $first=1;

# Handle each block separated by newline
while (<INPUT>) {
	my ($ver, $date) = split(/ /);
	my $ver2;
	$ver =~ s/^v//;
	chomp($date);
	$date =~ s/\(([0-9-]+)\)/$1/;
	#print "**$date**\n";
	my $ndate = UnixDate($date,"%a", "%b", "%d", "%Y");
	my $n2date = &UnixDate($date,"%a, %d %b %Y %H:%M:%S %z");
	#print "**$ndate**\n";
	my ($packager) = pb_conf_get("packager");

	if (($dtype eq "rpm") || ($dtype eq "fc")) {
		if ($ver !~ /-/) {
			if ($first eq 1) {
				$ver2 = "$ver-$pbtag$dsuf";
				$first=0;
			} else {
				$ver2 = "$ver-1$dsuf";
			}
		} else {
			$ver2 = "$ver$dsuf";
		}
		print $OUTPUT "* $ndate $packager->{$ENV{'PBPROJ'}} $ver2\n";
		print $OUTPUT "- Updated to $ver\n";
		}
	if ($dtype eq "deb") {
		print $OUTPUT "$pkg ($ver) unstable; urgency=low\n";
		print $OUTPUT "\n";
		}

	$tmp = <INPUT>;	
	while ($tmp !~ /^$/) {
		if ($dtype eq "deb") {
			$tmp =~ s/^- //;
			print $OUTPUT "  * $tmp";
		} elsif ($dtype eq "rpm") {
			print $OUTPUT "$tmp";
		} else {
			print $OUTPUT "$tmp";
		}
		last if (eof(INPUT));
		$tmp = <INPUT>;
	}
	print $OUTPUT "\n";

	if ($dtype eq "deb") {
		# Cf: http://www.debian.org/doc/debian-policy/ch-source.html#s-dpkgchangelog
		print $OUTPUT " -- $packager->{$ENV{'PBPROJ'}}  $n2date\n\n\n";
		}

	last if (eof(INPUT));
	last if ($dtype eq "announce");
}
close(INPUT);
}
1;
