#!/usr/bin/perl -w
#
# Tests ProjectBuilder::YAML functions

use strict;
use Data::Dumper;
use ProjectBuilder::Base;
use ProjectBuilder::YAML;

my $res;
eval
{
	require Test::More;
	Test::More->import();
	$res = $@;
	my ($tmv,$tmsv) = split(/\./,$Test::More::VERSION);
	if ($tmsv lt 87) {
		die "Test::More is not available in an appropriate version ($tmsv)";
	}
};

# Test appropriate version not found so no test will be performed here
if ($res) {
	require Test;
	Test->import();
	plan(tests => 1);
	print "# Faking tests as Test::More is not available in an appropriate version\n";
	ok(1,1);
	exit(0);
}

my $nt = 0;

$ENV{'TMPDIR'} = "/tmp";
pb_temp_init();
open(FILE,"> $ENV{'TMPDIR'}/conf1.yml") || die "Unable to create $ENV{'TMPDIR'}/conf1.yml";
print FILE "---\n";
print FILE "colon:\n";
print FILE "  mageia-3-x86_64: 'ex: test'\n";
print FILE "percent:\n";
print FILE "  mageia-3-x86_64: '%check'\n";
print FILE "truc:\n";
print FILE "  mageia-4-x86_64: 'la tete a toto'\n";
print FILE "yorro:\n";
print FILE "  mageia-3-x86_64: tartampion\n";
print FILE "zz:\n";
print FILE "  mageia-3-x86_64: ''\n";
close(FILE);

my $tab1 = pb_LoadFile("$ENV{'TMPDIR'}/conf1.yml");
open(FILE,"> $ENV{'TMPDIR'}/conf1bis.yml") || die "Unable to create $ENV{'TMPDIR'}/conf1bis.yml";
print FILE Dumper($tab1);
close(FILE);
my $cnt = pb_get_content("$ENV{'TMPDIR'}/conf1.yml");
my $tab2 = pb_Dump($tab1);
open(FILE,"> $ENV{'TMPDIR'}/test1bis.yml") || die "Unable to create $ENV{'TMPDIR'}/test1bis.yml";
print FILE Dumper($tab2);
close(FILE);
open(FILE,"> $ENV{'TMPDIR'}/test1.yml") || die "Unable to create $ENV{'TMPDIR'}/test1.yml";
print FILE "$tab2";
close(FILE);
my $content = pb_get_content("$ENV{'TMPDIR'}/test1.yml");
is($cnt, $content, "pb_DumpFile Test");
$nt++;

done_testing($nt);
