package ProjectBuilder;
use Mojo::Base 'Mojolicious';
use ProjectBuilder::Model::Confs;
use Data::Dumper;
use ProjectBuilder::YAML;
use JSON;

# This method will run once at server start
sub startup {
  my $self = shift;

  print Dumper($self);
  # Model
  $self->helper(confs => sub { state $confs = ProjectBuilder::Model::Confs->new() });

  # Load configuration from hash returned by config file - doesn't work for now
  #my $config = $self->plugin('Config' => { file => 'etc/pb-server.json' });

  # Configure the application
  #$self->secrets([split /:/, $ENV{'BLOG_SECRETS'} || 'super:s3cret']);
  #$self->secrets($config->{secrets});

  # Load Open API endpoins
  # /api             *       api
  #   +/confs        POST    "store"
  #   +/confs        GET     "list"
  #   +/confs/(:id)  PUT     "update"
  #   +/confs/(:id)  DELETE  "remove"
  #   +/confs/(:id)  GET     "show"
  my $c = {
		#schema => "v3",
		default_response_codes => [400, 401, 404, 500, 501],
		#default_response_name => 1,
		url => 'file:///usr/share/pb/api.yaml',
		};
  $self->plugin(OpenAPI => $c);
  print "After Plugin OpenAPI\n";
  #$self->plugin(OpenAPI => {schema_file => $self->home->rel_file('api.yaml'), schema => "v3"});

  # Regular web pages
  # /                GET
  # /confs           GET     confs
  # /confs/create    GET     "create_conf"
  # /confs           POST    "store_conf"
  # /confs/:id       GET     "show_conf"
  # /confs/:id/edit  GET     "edit_conf"
  # /confs/:id       PUT     "update_conf"
  # /confs/:id       DELETE  "remove_conf"

  # Router
  my $r = $self->routes;

  # Normal route to controller
  $r->get('/w')->to('example#welcome');
  $r->get('/' => sub { shift->redirect_to('confs') });
  $r->get('/confs')->to('conf#list');
  $r->get('/confs/create')->to('conf#create')->name('create_conf');
  $r->post('/confs')->to('conf#store')->name('store_conf');
  $r->get('/confs/:id')->to('conf#show')->name('show_conf');
  $r->get('/confs/:id/edit')->to('conf#edit')->name('edit_conf');
  $r->put('/confs/:id')->to('conf#update')->name('update_conf');
  $r->delete('/conconfid')->to('conf#remove')->name('remove_conf');

  # Swagger2 module not maintained anymore
  #require Swagger2::Editor;
  #my $editor = Swagger2::Editor->new(specification_file => $self->home->rel_file('api.yaml'));
  #$r->route('/editor')->detour(app => $editor);
}

1;
