#
# $Id$
#
%global debug_package %{nil}

Summary:        PBSUMMARY
Summary(fr):    Archiveur écrivant des archives au format tar

Name:           PBPKG
Version:        PBVER
Release:        PBTAGPBSUF
License:        PBLIC
Group:          PBGRP
Url:            https://sourceforge.net/projects/s-tar/
Source:         PBURL
BuildRequires:	gcc
BuildRequires:	libattr-devel
BuildRequires:	libacl-devel
BuildRequires:	pkgconfig(ext2fs)

%description
PBDESC

%package devel
Summary:        PBSUMMARY
Group:          Archiving/Backup

%description devel
devel files for star

%description -l fr
Archiveur écrivant des archives au format tar avec support des ACLs.

%prep
%setup -q

for PLAT in %{arm} aarch64 x86_64; do
    for AFILE in gcc cc; do
            [ ! -e RULES/${PLAT}-linux-${AFILE}.rul ] \
            && ln -s i586-linux-${AFILE}.rul RULES/${PLAT}-linux-${AFILE}.rul
    done
done

%build
make COPTX=-DTRY_EXT2_FS LDOPTX="%{ldflags}" GMAKE_NOWARN=true MANDIR=man CFLAGS="-O2 -g -pipe -Wformat -Werror=format-security -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector --param=ssp-buffer-size=4 -mtune=generic -fasynchronous-unwind-tables"

%install
make GMAKE_NOWARN=true "INS_BASE=${RPM_BUILD_ROOT}/%{_prefix}" "INS_RBASE=${RPM_BUILD_ROOT}/" MANDIR=man install

# The following files conflict with GNU tar & mtr
rm -f ${RPM_BUILD_ROOT}/%{_bindir}/{,us}tar
rm -f ${RPM_BUILD_ROOT}/%{_bindir}/mt
rm -f ${RPM_BUILD_ROOT}/%{_mandir}/man1/match.1
# The following files conflict with the rmt package
rm -f ${RPM_BUILD_ROOT}/%{_sbindir}/rmt
# The following devel files conflict with cdrecord
rm -f ${RPM_BUILD_ROOT}/%{_includedir}/avoffset.h
rm -f ${RPM_BUILD_ROOT}/%{_libdir}/libdeflt.a
rm -f ${RPM_BUILD_ROOT}/%{_libdir}/libschily.a

# The other libs may be in the wrong place
if [ _"%{_libdir}" != _"/usr/lib" ]; then
	chmod 644 ${RPM_BUILD_ROOT}/usr/lib/lib*.a ${RPM_BUILD_ROOT}/usr/lib/profiled/*.a
	mkdir -p ${RPM_BUILD_ROOT}/%{_libdir}
	mv ${RPM_BUILD_ROOT}/usr/lib/* ${RPM_BUILD_ROOT}/%{_libdir}
else
	chmod 644 ${RPM_BUILD_ROOT}/%{_libdir}/lib*.a ${RPM_BUILD_ROOT}/%{_libdir}/profiled/*.a
fi

# fwang: I don't know why it installs to here
rm -f ${RPM_BUILD_ROOT}%{_datadir}/doc/rmt/default-rmt.sample
# Removing it now, it's done below
rm -rf ${RPM_BUILD_ROOT}%{_datadir}/doc/star
%files
%defattr(-,root,root,-)
%doc README* CDDL* LGPL* COPYING AN-%{version}
%{_bindir}/*
%{_mandir}/man1/*.1*
%{_sysconfdir}/default/*

%files devel
%{_includedir}/schily/*.h
%{_includedir}/schily/*/*.h
%{_libdir}/lib*.a
%{_libdir}/profiled/*.a
%{_mandir}/man3/*
%{_mandir}/man5/*

%changelog
PBLOG

