#
# Project Builder configuration file
# For project LinuxCOE
#
# $Id: linuxcoe.pb,v 1.16 2008/02/17 23:24:34 bryang Exp $
#
#

#
# What is the project URL
#
pburl linuxcoe = cvs://:pserver:anonymous@linuxcoe.cvs.sourceforge.net:/cvsroot/linuxcoe

#
# Packager label
#
pbpackager linuxcoe = Louis Bouchard and Bruno Cornec <bruno@project-builder.org>

#
# For delivery to a machine by SSH (potentially the FTP server)
# Needs hostname, account and directory
#
sshhost default = www.mondorescue.org
sshlogin default = bruno
sshdir default = /mondo/ftp
sshport default = 22

#
# For Virtual machines management
# Naming convention to follow: distribution name (as per ProjectBuilder::Distribution)
# followed by '_' and by release number
# a .vmtype extension will be added to the resulting string
# a QEMU rhel_3 here means that the VM will be named rhel_3.qemu
#
vmlist linuxcoe = mandrake-10.1-i386,mandrake-10.2-i386,mandriva-2006.0-i386,mandriva-2007.0-i386,mandriva-2007.1-i386,mandriva-2008.0-i386,redhat-7.3-i386,redhat-9-i386,fedora-4-i386,fedora-5-i386,fedora-6-i386,rhel-3-i386,rhel-4-i386,rhel-5-i386,suse-10.0-i386,suse-10.1-i386,suse-10.2-i386,suse-10.3-i386,sles-9-i386,sles-10-i386,gentoo-nover-i386,debian-3.1-i386,debian-4.0-i386,ubuntu-6.06-i386,ubuntu-7.04-i386,ubuntu-7.10-i386,mandriva-2007.0-x86_64,mandriva-2007.1-x86_64,mandriva-2008.0-x86_64,fedora-6-x86_64,fedora-8-x86_64,rhel-4-x86_64,rhel-5-x86_64,suse-10.2-x86_64,suse-10.3-x86_64,sles-10-x86_64,gentoo-nover-x86_64,debian-4.0-x86_64,ubuntu-7.04-x86_64,ubuntu-7.10-x86_64

velist linuxcoe = fedora-7-i386

vetype linuxcoe = chroot
ventp default = pool.ntp.org
velogin linuxcoe = pb
vepath linuxcoe = /var/lib/mock
veconf linuxcoe = /etc/mock
verebuild linuxcoe = false
#
# Valid values for vmtype are
# qemu, (vmware, xen, ... TBD)
vmtype linuxcoe = qemu
vmntp linuxcoe = pool.ntp.org

# We suppose we can commmunicate with the VM through SSH
vmhost linuxcoe = localhost
vmlogin linuxcoe = pb
vmport linuxcoe = 2224
# Timeout to wait when VM is launched/stopped
vmtmout default = 120

# per VMs needed paramaters
#vmopt qemu = -m 256 -nographic -daemonize
vmopt linuxcoe = -m 384 -daemonize
vmpath linuxcoe = /users/qemu
vmsize linuxcoe = 5G 

#
# Global version/tag for the project
#
projver linuxcoe = cvs
projtag linuxcoe = 1

# Hash of default package/package directory
#
defpkgdir linuxcoe-sd-base = SystemDesigner
defpkgdir linuxcoe-sd-docs = docs

# Hash of additional package/package directory
#
extpkgdir linuxcoe-sd-data-centos = SystemDesigner-CentOS
extpkgdir linuxcoe-sd-data-debian = SystemDesigner-Debian
extpkgdir linuxcoe-sd-data-fedora = SystemDesigner-Fedora
extpkgdir linuxcoe-sd-data-opensuse = SystemDesigner-OpenSUSE
extpkgdir linuxcoe-sd-data-scientific = SystemDesigner-Scientific
extpkgdir linuxcoe-sd-data-ubuntu = SystemDesigner-Ubuntu
#
extpkgdir linuxcoe-sd-data-nld = SystemDesigner-NLD
extpkgdir linuxcoe-sd-data-rhel = SystemDesigner-RHEL
extpkgdir linuxcoe-sd-data-sles = SystemDesigner-SLES
extpkgdir linuxcoe-sd-data-suse = SystemDesigner-SuSE
extpkgdir linuxcoe-sd-data-vmware = SystemDesigner-VMware

# Hash of valid version names
#
version linuxcoe = cvs,devel,stable
testver linuxcoe = true

# List of additional files on which to apply filters
# Files are mentioned relatively to pbroot
#
#filteredfiles linuxcoe-sd-base =
#filteredfiles linuxcoe-sd-docs = 
