Summary: LinuxCOE SystemDesigner web interface
Name: PBPKG
Version: PBVER
Release: PBTAGPBSUF
License: GPL
URL: http://linuxcoe.sourceforge.net/
Group: PBGRP
# Copyright: 2000-2007 Hewlett-Packard Development Company, L.P
# Original Packager: Louis Bouchard <louis.bouchard@hp.com>
#
# Source Section
#
Source: PBSRC

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(id -u -n)
BuildArch: noarch
Requires: perl, sudo, PBDEP

%description
LinuxCOE SystemDesigner is a unifying web application that allows
a user to repeatably install, configure, and maintain different
Linux system installations. It's CGI-based interface provides means
to generate boot images for network or local media based installations,
save profiles that store custom installation preferences for later re-use,
and retrofit already deployed systems by overlaying other value-add components.


%prep
%setup -q

%build
# For the moment done here. Would be better to give it to pb. Needs discussion
export httpdcfgdir=PBHTTPDCONF
export docrootdir=PBHTTPDDOCROOT
export httpd_user=PBHTTPDUSER
export httpd_group=PBHTTPDGROUP
export sudoers_cfg=PBSUDOERS
export webalias=PBWEBALIAS
export webworkdir=PBWEBWORKDIR

# macro configure doesn't work. (Do not put a percent before the word)
./configure --prefix=PBROOTINSTALL --sysconfdir=PBETCINSTALL --localstatedir=%{_var} --mandir=%{_mandir} --without-APACHECTL --without-SUDO --without-PERLMOD --without-MKISOFS --without-SENDMAIL
make

%install
%{__rm} -rf %{buildroot}
make DESTDIR="$RPM_BUILD_ROOT" install
mkdir -p $RPM_BUILD_ROOT/%{_sysconfdir}/logrotate.d
export VARLOG=%{_var}/log
cat > $RPM_BUILD_ROOT/%{_sysconfdir}/logrotate.d/LinuxCOE << EOF
$VARLOG/* {
    create 640 PBHTTPDUSER PBHTTPDGROUP
    rotate 4
    monthly
    missingok
    compress
    prerotate
        /etc/init.d/httpd closelogs > /dev/null 2>&1
    endscript
    postrotate
        /etc/init.d/httpd closelogs > /dev/null 2>&1
    endscript
}
EOF

%post
#
# Invoke post action script
#
PBROOTINSTALL/bin/post-actions -i -v
/etc/init.d/httpd reload
if [ -x /usr/sbin/selinuxenabled ]; then
	/usr/sbin/selinuxenabled
	if [ $? -eq 0 ]; then
		echo "WARNING: desactivating SELinux as it is not yet compatible with"
		echo "LinuxCOE systemDesigner. You'll have to reboot to take it in account"
		perl -pi -e 's/SELINUX=.*/SELINUX=disabled/' /etc/sysconfig/selinux
	fi
fi

# THis is not clear at the moment when doing -U updates 
# this tend to be called after the %post above thus 
# defeating that task :-(
#%preun
#if [ -x PBROOTINSTALL/bin/post-actions ]; then
	#PBROOTINSTALL/bin/post-actions -u -v
#fi
#perl -pi -e 's/^PBHTTPDUSER.*//' /etc/sudoers
#/etc/init.d/httpd reload

%clean
%{__rm} -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%config(noreplace) PBETCINSTALL 
%config %{_sysconfdir}/logrotate.d/LinuxCOE
%doc AUTHORS ChangeLog COPYING INSTALL NEWS README
%{_var}/cache/*
%{_var}/log/*
%{_localstatedir}/*
PBROOTINSTALL

%changelog
PBLOG
