#
# Project Builder configuration file
# For project netperf
#
# $Id$
#

#
# What is the project URL
#
#pburl netperf = svn://svn.netperf.org/netperf/devel
#pburl netperf = svn://svn+ssh.netperf.org/netperf/devel
#pburl netperf = cvs://cvs.netperf.org/netperf/devel
#pburl netperf = http://www.netperf.org/src/netperf-devel.tar.gz
pburl netperf = ftp://ftp.netperf.org/netperf/netperf-2.4.4.tar.bz2
#pburl netperf = file:///src/netperf-devel.tar.gz
#pburl netperf = dir:///src/netperf-devel

# Check whether project is well formed 
# (containing already a directory with the project-version name)
pbwf netperf = 1

#
# Packager label
#
pbpackager netperf = Bruno Cornec <bruno@project-builder.org>
#

# For delivery to a machine by SSH (potentially the FTP server)
# Needs hostname, account and directory
#
sshhost netperf = www.project-builder.org
sshlogin netperf = pb
sshdir netperf = /mondo/ftp
sshport netperf = 22

#
# For Virtual machines management
# Naming convention to follow: distribution name (as per ProjectBuilder::Distribution)
# followed by '-' and by release number
# followed by '-' and by architecture
# a .vmtype extension will be added to the resulting string
# a QEMU rhel-3-i286 here means that the VM will be named rhel-3-i386.qemu
#
vmlist netperf = mandrake-10.1-i386,mandrake-10.2-i386,mandriva-2006.0-i386,mandriva-2007.0-i386,mandriva-2007.1-i386,mandriva-2008.0-i386,redhat-7.3-i386,redhat-9-i386,fedora-4-i386,fedora-5-i386,fedora-6-i386,fedora-7-i386,fedora-8-i386,rhel-3-i386,rhel-4-i386,rhel-5-i386,suse-10.0-i386,suse-10.1-i386,suse-10.2-i386,suse-10.3-i386,sles-9-i386,sles-10-i386,gentoo-nover-i386,debian-3.1-i386,debian-4.0-i386,ubuntu-6.06-i386,ubuntu-7.04-i386,ubuntu-7.10-i386,mandriva-2007.0-x86_64,mandriva-2007.1-x86_64,mandriva-2008.0-x86_64,fedora-6-x86_64,fedora-7-x86_64,fedora-8-x86_64,rhel-4-x86_64,rhel-5-x86_64,suse-10.2-x86_64,suse-10.3-x86_64,sles-10-x86_64,gentoo-nover-x86_64,debian-4.0-x86_64,ubuntu-7.04-x86_64,ubuntu-7.10-x86_64

#
# Valid values for vmtype are
# qemu, (vmware, xen, ... TBD)
vmtype netperf = qemu

# Hash for VM stuff on vmtype
#vmntp default = pool.ntp.org

# We suppose we can commmunicate with the VM through SSH
vmhost netperf = localhost
vmlogin netperf = pb
vmport netperf = 2222

# Timeout to wait when VM is launched/stopped
vmtmout default = 120

# per VMs needed paramaters
vmopt netperf = -m 384 -daemonize
vmpath netperf = /users/qemu
vmsize netperf = 5G

# 
# For Virtual environment management
# Naming convention to follow: distribution name (as per ProjectBuilder::Distribution)
# followed by '-' and by release number
# followed by '-' and by architecture
# a .vetype extension will be added to the resulting string
# a chroot rhel-3-i286 here means that the VE will be named rhel-3-i386.chroot
#
#velist netperf = fedora-7-i386

# VE params
#vetype netperf = chroot
#ventp default = pool.ntp.org
#velogin netperf = pb
#vepath netperf = /var/lib/mock
#veconf netperf = /etc/mock
#verebuild netperf = false

#
# Global version/tag for the project
#
projver netperf = 2.4.4
projtag netperf = 1

# Hash of valid version names
version netperf = devel

# Adapt to your needs:
# Optional if you need to overwrite the global values above
#
#pkgver netperf = stable
#pkgtag netperf = 3
# Hash of default package/package directory
defpkgdir netperf = netperf-2.4.4
# Hash of additional package/package directory
#extpkgdir minor-pkg = dir-minor-pkg

# List of files per pkg on which to apply filters
# Files are mentioned relatively to pbroot/defpkgdir
#filteredfiles netperf = Makefile.PL,configure.in,install.sh,netperf.8
#supfiles netperf = netperf.init
