#
# Project Builder configuration file
# For project mondorescue
#
# $Id$
#

pburl mondorescue = svn+ssh://svn.mondorescue.org/mondo/svn/mondorescue
#
#
# Packager label
pbpackager mondorescue = Bruno Cornec <bruno@mondorescue.org>

#
# For delivery to a machine by SSH (potentially the FTP server)
# Needs hostname, account and directory
#
sshhost mondorescue = www.mondorescue.org
sshlogin mondorescue = bruno
sshdir mondorescue = /mondo/ftp
sshport mondorescue = 22

#
# For Virtual machines management
# Naming convention to follow: distribution name (as per ProjectBuilder::Distribution)
# followed by '_' and by release number
# a .vmtype extension will be added to the resulting string
# a QEMU rhel_3 here means that the VM will be named rhel_3.qemu
#
vmlist mondorescue = mandrake-10.1-i386,mandrake-10.2-i386,mandriva-2006.0-i386,mandriva-2007.0-i386,mandriva-2007.1-i386,mandriva-2008.0-i386,redhat-7.3-i386,redhat-9-i386,fedora-4-i386,fedora-5-i386,fedora-6-i386,fedora-7-i386,fedora-8-i386,rhel-3-i386,rhel-4-i386,rhel-5-i386,suse-10.0-i386,suse-10.1-i386,suse-10.2-i386,suse-10.3-i386,sles-9-i386,sles-10-i386,gentoo-nover-i386,debian-3.1-i386,debian-4.0-i386,ubuntu-6.06-i386,ubuntu-7.04-i386,ubuntu-7.10-i386,mandriva-2007.0-x86_64,mandriva-2007.1-x86_64,mandriva-2008.0-x86_64,fedora-6-x86_64,fedora-7-x86_64,fedora-8-x86_64,rhel-4-x86_64,rhel-5-x86_64,suse-10.2-x86_64,suse-10.3-x86_64,sles-10-x86_64,gentoo-nover-x86_64,debian-4.0-x86_64,ubuntu-7.04-x86_64,ubuntu-7.10-x86_64

#
# Valid values for vmtype are
# qemu, (vmware, xen, ... TBD)
vmtype mondorescue = qemu
vmntp mondorescue = pool.ntp.org

# We suppose we can commmunicate with the VM through SSH
vmhost mondorescue = localhost
vmlogin mondorescue = pb
vmport mondorescue = 2222
# Timeout to wait when VM is launched/stopped
vmtmout default = 120

vmsize mondorescue = 5G

# per VMs needed paramaters
#vmopt mondorescue = -m 256 -nographic -daemonize
vmopt mondorescue = -m 384 -daemonize
vmpath mondorescue = /users/qemu

testver mondorescue = true
projver mondorescue = 2.2.6
projtag mondorescue = 1

# Hash of default package/package directory
defpkgdir mondo = mondo
defpkgdir mindi = mindi

pkgver mindi = 2.0.2
pkgver mindi-busybox = 1.7.3
pkgtag mindi-busybox = 2

# Hash of additional package/package directory
extpkgdir mindi-busybox = mindi-busybox
extpkgdir mondo-doc = mondo-doc
# Gentoo doesn't name the package mondo as it conflicts
# So we create an additional fake package just for it
extpkgdir mondo-rescue = mondo

# Hash of valid version names
version mondorescue = devel,stable

# List of additional files on which to apply filters
# Files are mentioned relatively to pbroot
filteredfiles mondo = configure.in
filteredfiles mondo-doc = mondorescue-howto.sgml,mondoarchive.8,mondorestore.8,mindi.8
filteredfiles mindi = rootfs/sbin/init,mindi,install.sh
filteredfiles mindi-busybox = Makefile
filteredfiles mondo-website = top.shtml
