#
# $Id$
#

Summary:        dploy.org common tools
Summary(fr):    Outils communs pour dploy.org

Name:           PBPKG
Version:        PBVER
Release:        PBTAGPBSUF
License:        GPL
Group:          PBGRP
Url:            PBURL
Source:         PBSRC
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(id -u -n)
Requires:       openssh, PBDEP

%description
PBDESC

%description -l fr
Outils communs pour dploy.org

%prep
%setup -q

%install
%{__rm} -rf $RPM_BUILD_ROOT
export DESTDIR=$RPM_BUILD_ROOT
export PREFIX=%{_exec_prefix}
export CONFDIR=%{_sysconfdir}/PBPROJ
./install.sh 

%clean
%{__rm} -rf $RPM_BUILD_ROOT

%files
%defattr(-,dploy,dploy)
%doc ChangeLog
#%doc INSTALL COPYING README AUTHORS NEWS
%config(noreplace) %{_sysconfdir}/PBPROJ

%pre
# Create dploy Account and group if needed
grep -qE '^dploy:' /etc/group
if [ $? -ne 0 ]; then
	addgroup dploy
fi
grep -qE '^dploy:' /etc/passwd
if [ $? -ne 0 ]; then
	adduser dploy dploy
fi

%post
# Open ssh access for dploy account with generated keys
mkdir -p ~dploy/.ssh
chmod 700 ~dploy/.ssh
keyf=~dploy/.ssh/authorized_keys
if [ -f $keyf ]; then
	key=`cut -d' ' -f2 %{_sysconfdir}/PBPROJ/keys/dploy_id_dsa.pub`
	grep -qE \'$key\' $keyf
	if [ $? -ne 0 ]; then
		cat %{_sysconfdir}/PBPROJ/keys/dploy_id_dsa.pub >> $keyf
	fi
else
	cp %{_sysconfdir}/PBPROJ/keys/dploy_id_dsa.pub $keyf
	chown dploy:dploy $keyf
	chmod 600 $keyf
fi

%changelog
PBLOG
