#
# Project Builder configuration file
# For project dploy
#
# $Id$
#

#
# Which CMS system is used (Subversion, CVS or tar file content extracted)
#
cms dploy = svn
#cms dploy = cvs
#cms dploy = flat

#
# Packager label
#
packager dploy = "Bruno Cornec <bruno@dploy.org>"
#

# For delivery to a machine by SSH (potentially the FTP server)
# Needs hostname, account and directory
#
sshhost dploy = www.dploy.org
sshlogin dploy = bruno
sshdir dploy = /dploy/ftp
sshport dploy = 22

#
# For Virtual machines management
# Naming convention to follow: distribution name (as per ProjectBuilder::Distribution)
# followed by '_' and by release number
# a .vmtype extension will be added to the resulting string
# a QEMU rhel_3 here means that the VM will be named rhel_3.qemu
#
vmlist dploy = mandrake_10.1,mandrake_10.2,mandriva_2006.0,mandriva_2007.0,mandriva_2007.1,mandriva_2008.0,redhat_7.3,redhat_9,fedora_4,fedora_5,fedora_6,fedora_7,rhel_3,rhel_4,rhel_5,suse_10.0,suse_10.1,suse_10.2,suse_10.3,sles_9,sles_10,gentoo_nover,debian_3.1,debian_4.0,ubuntu_6.06,ubuntu_7.04,ubuntu_7.10

#
# Valid values for vmtype are
# qemu, (vmware, xen, ... TBD)
vmtype dploy = qemu

# Hash for VM stuff on vmtype
vmntp default = pool.ntp.org

# We suppose we can commmunicate with the VM through SSH
vmhost dploy = localhost
vmlogin dploy = pb
vmport dploy = 2225

# Timeout to wait when VM is launched/stopped
vmtmout default = 120

# per VMs needed paramaters
vmopt dploy = -m 384 -daemonize
vmpath dploy = /home/qemu
vmsize dploy = 5G

#
# Global version/tag for the project
#
projver dploy = devel
projtag dploy = 1

# Adapt to your needs:
# Optional if you need to overwrite the global values above
#
pkgver dploy-dhcp = devel
pkgver dploy-common = devel
pkgver dploy-pxe = devel
#pkgtag dploy-dhcp = 3
#pkgver nil
#pkgtag nil

# Hash of default package/package directory
defpkgdir dploy-dhcp = dploy-dhcp
defpkgdir dploy-common = dploy-common
defpkgdir dploy-pxe = dploy-pxe

# Hash of additional package/package directory
#extpkgdir pkg1-doc = pkg1-docdir

# Hash of valid version names
version pb = devel,stable

# List of files per pkg on which to apply filters
# Files are mentioned relatively to pbroot/defpkgdir
filteredfiles dploy-dhcp = install.sh,bin/dploy-add2dhcp
filteredfiles dploy-common = install.sh
#filteredfiles pkg1-doc = configure.in
