#!/usr/bin/perl -w
#
# Creates common environment for SVN/CVS repository
#
# $Id$
#

require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw(get_toolhome);

use strict;

# Expects we are in the right directory to launch CMS commands

my @args = ("svn", "info", "2>&1", "/dev/null");
my $ret;
system(@args) == 0 or die "system @args failed: $?";
if ($? == -1) {
	print "failed to execute: $!\n";
} elsif ($? & 127) {
	printf "child died with signal %d, %s coredump\n", ($? & 127),  ($? & 128) ? 'with' : 'without';
} else {
	$ret =  $? >> 8;
	if ($ret == 0) {
		$ENV{'REVISION'}=`(cd $TOOLHOME/.. ; svnversion .)`;
		$ENV{'CMSLOG'}="svn log";
		$ENV{'CMSEXP'}="svn export";
	} else {
		# By default if not SVN take CVS
		$ENV{'REVISION'}=`(cd $TOOLHOME/.. ; cvs  rannotate  -f . 2>&1 | awk '{print $1}' | grep -E '^[0-9]' | cut -d. -f2 |sort -nu | tail -1)`;
		$ENV{'CMSLOG'}="cvs log";
		$ENV{'CMSEXP'}="cvs export"
		$ENV{'CVSROOT'}=$ENV{'CVSVAR'};
	}
}
1;
