#!/bin/bash
#
# Create env depending on the distro on which we are
#
# $Id$
#
# Input parameters : $ddir (distro name) and $dver (distro version)
# If they do not exist then deduce from current distro
# Exports : $dfam (distro family) $suf (pkg suffix) $dtype (distro type) TOPBUILDDIR (dir to build packages) 

#
# Guess ddir and dver from the underlying distro
#
if [ _"$ddir" = _"" ]; then
	if [ -e /etc/mandriva-release ]; then
		export ddir="mandriva"
		export dver=`awk '{print $4}' /etc/mandriva-release`
	elif [ -e /etc/mandrake-release ]; then
		export ddir="mandrake"
		export dver=`awk '{print $3}' /etc/mandrake-release`
	elif [ -e /etc/redhat-release ]; then
		grep -q Enterprise /etc/redhat-release
		if [ $? -eq 0 ]; then
			export ddir="rhel"
			export dver=`awk '{print $7}' /etc/redhat-release`
		elif grep -q Fedora /etc/redhat-release ; then
			export ddir="fedora"
			grep -qi core /etc/redhat-release
			if [ $? -eq 0 ]; then
				export dver=`awk '{print $4}' /etc/redhat-release`
			else
				export dver=`awk '{print $3}' /etc/redhat-release`
			fi
		elif grep -q CentOS /etc/redhat-release ; then
			export ddir="centos"
			export dver=`awk '{print $3}' /etc/redhat-release | cut -d. -f1`
		else
			export ddir="redhat"
			export dver=`awk '{print $5}' /etc/redhat-release`
		fi
	elif [ -e /etc/SuSE-release ]; then
		grep -q Enterprise /etc/SuSE-release
		if [ $? -eq 0 ]; then
			export ddir="sles"
			export dver=`head -1 /etc/SuSE-release | awk '{print $5}'`
		elif grep -q openSUSE /etc/SuSE-release ; then
			export ddir="suse"
			export dver=`head -1 /etc/SuSE-release | awk '{print $2}'`
		else
			export ddir="suse"
			export dver=`head -1 /etc/SuSE-release | awk '{print $3}'`
		fi
	elif [ -e /etc/slackware-version ]; then
		export ddir="slackware"
		export dver=`awk '{print $2}' /etc/slackware-version | cut -d. -f1-2`
	elif [ -e /etc/gentoo-release ]; then
		export ddir="gentoo"
		export dver=`awk '{print $5}' /etc/gentoo-release | cut -d. -f1-2`
	elif [ -e /etc/debian_version ]; then
		export ddir="debian"
		export dver=`cat /etc/debian_version`
		# Debian assigns release names only once a release actually happens.
		# Debian does not distinguish between testing and unstable because
		# unstable today is what testing will be in about ten days time. So,
		# in case we encounter "tesing/unstable", we assume unstable, i.e. sid.
		# Note that for released versions, the numeric version will be contained
		# in debian_version, e.g. on a sarge system, the value will be '3.1'.
		if [ $dver = "testing/unstable" ]; then
			export dver = "sid"
		fi
		if [ -e /etc/lsb-release ]; then
			grep -qi ubuntu /etc/lsb-release
			if  [ $? -eq 0 ]; then
				export ddir="ubuntu"
				export dver=`cat /etc/lsb-release | grep DISTRIB_RELEASE | cut -d= -f2`
			fi
		fi
	elif [ -e /etc/motd ]; then
		head -1 /etc/motd | grep -q FreeBSD
		if [ $? -eq 0 ]; then
			export ddir="freebsd"
			export dver=`head -1 /etc/motd | awk '{print $2}' /etc/motd | cut -d- -f1`
		else
			export ddir="unknown"
			export dver=""
		fi
	else
		export ddir="unknown"
		export dver=""
	fi
fi

#
# Generate all other parameters
#
if [ $ddir = "debian" -o $ddir = "ubuntu" ]; then
	dfam="debian"
	dtype="deb"
	suf=".${ddir}${dver}"
elif [ $ddir = "gentoo" ]; then
	dfam="gentoo"
	dtype="ebuild"
	dver1=`echo ${dver} | sed "s/\.//"`
	suf=".${ddir}${dver1}"
elif [ $ddir = "slackware" ]; then
	dfam="slackware"
	dtype="tgz"
	suf=".${dfam}${dver}"
elif [ $ddir = "sles" -o $ddir = "suse" ]; then
	dfam="suse"
	dtype="rpm"
	suf=".${ddir}${dver}"
elif [ $ddir = "fedora" -o $ddir = "redhat" -o $ddir = "rhel" -o $ddir = "centos" ]; then
	dfam="redhat"
	dtype="rpm"
	dver1=`echo ${dver} | sed "s/\.//"`
	if [ $ddir = "fedora" ]; then
		suf=".fc${dver1}"
	elif [ $ddir = "centos" ]; then
		dver1=`echo ${dver} | sed "s/\.[0-9]//"`
		suf=".centos${dver1}"
	elif [ $ddir = "redhat" ]; then
		suf=".rh${dver1}"
	else
		suf=".rhel${dver1}"
	fi
elif [ $ddir = "mandrake" ]; then
	dfam="mandriva"
	dtype="rpm"
	suf=".`echo $dver | sed 's/\.//'`mdk"
elif [ $ddir = "mandriva" ]; then
	dfam="mandriva"
	dtype="rpm"
	suf=".`echo $dver | sed 's/\.//'`mdv"
elif [ $ddir = "freebsd" ]; then
	dfam="freebsd"
	dtype="port"
	suf=".`echo $dver | sed 's/\.//'`fbsd"
else
	dfam="unknown"
	dtype="unknown"
	suf="unknown"
fi

export dfam
export dtype
export suf

#
# Additional exports and preparation for some distros
#

# Default
export TOPBUILDDIR=${TOPDIR}/../build

if [ _"$dtype" = _"rpm" ]; then
	export TOPBUILDDIR=`rpmquery --eval '%{_topdir}' 2> /dev/null`
	export ARCH=`rpm --showrc | egrep "^build arch" | awk '{print $4}'`
	mkdir -p ${TOPBUILDDIR}/{RPMS,SRPMS,SPECS,SOURCES,BUILD}
	if [ $? -ne 0 ]; then
		echo "Please ensure that you can write into ${TOPBUILDDIR}"
		echo "Solution: setup _topdir in your ~/.rpmmacros or"
		echo "chown the ${TOPBUILDDIR} to your uid"
		exit -1
	fi
elif [ _"$dtype" = _"deb" ]; then
	mkdir -p ${TOPBUILDDIR}
elif [ _"$dtype" = _"port" ]; then
	mkdir -p ${TOPBUILDDIR}
elif [ _"$dfam" = _"slackware" ]; then
	mkdir -p ${TOPBUILDDIR}/install
elif [ _"$dtype" = _"ebuild" ]; then
	mkdir -p ${TOPBUILDDIR}/portage
fi
