#!/usr/bin/perl -w
#
# ProjectBuilder Changelog module
# Changelog management subroutines brought by the the Project-Builder project
#
# $Id$
#
# Copyright B. Cornec 2007
# Provided under the GPL v2

package ProjectBuilder::Changelog;

use strict 'vars';
use Data::Dumper;
use English;
use Date::Manip;
use POSIX qw(strftime);
use lib qw (lib);
use ProjectBuilder::Base;
use ProjectBuilder::Conf;

# Inherit from the "Exporter" module which handles exporting functions.
 
use Exporter;
 
# Export, by default, all the functions into the namespace of
# any code which uses this module.
 
our @ISA = qw(Exporter);
our @EXPORT = qw(pb_changelog);

=pod

=head1 NAME

ProjectBuilder::Changelog, part of the project-builder.org - module dealing with changelog management

=head1 DESCRIPTION

blabla

=cut

sub pb_changelog {

my $dtype = shift;
my $pkg = shift;
my $pbver = shift;
my $pbtag = shift;
my $dsuf = shift;
my $path = shift;
my $OUTPUT = shift;
my $doit = shift;
my $chglog = shift || undef;

my $log = "";

# For date handling
$ENV{LANG}="C";

if ((not (defined $dtype)) || ($dtype eq "") || 
		(not (defined $pkg)) || ($pkg eq "") || 
		(not (defined $pbver)) || ($pbver eq "") || 
		(not (defined $pbtag)) || ($pbtag eq "") || 
		(not (defined $dsuf)) || ($dsuf eq "") || 
		(not (defined $path)) || ($path eq "") || 
		(not (defined $OUTPUT)) || ($OUTPUT eq "") ||
		(not (defined $doit)) || ($doit eq "")) {
	print $OUTPUT "\n";
	return;
}

if (((not defined $chglog) || (! -f $chglog)) && ($doit eq "yes")) {
	#pb_log(2,"No ChangeLog file ($chglog) for $pkg\n";
	print $OUTPUT "\n";
	return;
}

my $date;
my $ndate;
my $n2date;
my $ver;
my $ver2;
my ($pbpackager) = pb_conf_get("pbpackager");

if (not defined $pbpackager->{$ENV{'PBPROJ'}}) {
	$pbpackager->{$ENV{'PBPROJ'}} = "undefined\@noproject.noorg";
}

# If we don't need to do it, or don't have it fake something
if (((not defined $chglog) || (! -f $chglog)) && ($doit ne "yes")) {
	my @date = pb_get_date();
	$date = strftime("%Y-%m-%d", @date);
	$ndate = &UnixDate($date,"%a", "%b", "%d", "%Y");
	$n2date = &UnixDate($date,"%a, %d %b %Y %H:%M:%S %z");
	if (($dtype eq "rpm") || ($dtype eq "fc")) {
		$ver2 = "$pbver-$pbtag$dsuf";
		print $OUTPUT "* $ndate $pbpackager->{$ENV{'PBPROJ'}} $ver2\n";
		print $OUTPUT "- Updated to $pbver\n";
		}
	if ($dtype eq "deb") {
		print $OUTPUT "$pkg ($pbver) unstable; urgency=low\n";
		print $OUTPUT "\n";
		print $OUTPUT " -- $pbpackager->{$ENV{'PBPROJ'}}  $n2date\n\n\n";
		}
	return;
}

open(INPUT,"$chglog") || die "Unable to open $chglog (read)";

# Skip first 4 lines
my $tmp = <INPUT>;
$tmp = <INPUT>;
$tmp = <INPUT>;
if ($dtype eq "announce") {
	print $OUTPUT $tmp;
}
$tmp = <INPUT>;
if ($dtype eq "announce") {
	print $OUTPUT $tmp;
}

my $first=1;

# Handle each block separated by newline
while (<INPUT>) {
	($ver, $date) = split(/ /);
	$ver =~ s/^v//;
	chomp($date);
	$date =~ s/\(([0-9-]+)\)/$1/;
	#pb_log(2,"**$date**\n";
	$ndate = UnixDate($date,"%a", "%b", "%d", "%Y");
	$n2date = UnixDate($date,"%a, %d %b %Y %H:%M:%S %z");
	#pb_log(2,"**$ndate**\n";

	if (($dtype eq "rpm") || ($dtype eq "fc")) {
		if ($ver !~ /-/) {
			if ($first eq 1) {
				$ver2 = "$ver-$pbtag$dsuf";
				$first=0;
			} else {
				$ver2 = "$ver-1$dsuf";
			}
		} else {
			$ver2 = "$ver$dsuf";
		}
		print $OUTPUT "* $ndate $pbpackager->{$ENV{'PBPROJ'}} $ver2\n";
		print $OUTPUT "- Updated to $ver\n";
		}
	if ($dtype eq "deb") {
		print $OUTPUT "$pkg ($ver) unstable; urgency=low\n";
		print $OUTPUT "\n";
		}

	$tmp = <INPUT>;	
	while ($tmp !~ /^$/) {
		if ($dtype eq "deb") {
			$tmp =~ s/^- //;
			print $OUTPUT "  * $tmp";
		} elsif ($dtype eq "rpm") {
			print $OUTPUT "$tmp";
		} else {
			print $OUTPUT "$tmp";
		}
		last if (eof(INPUT));
		$tmp = <INPUT>;
	}
	print $OUTPUT "\n";

	if ($dtype eq "deb") {
		# Cf: http://www.debian.org/doc/debian-policy/ch-source.html#s-dpkgchangelog
		print $OUTPUT " -- $pbpackager->{$ENV{'PBPROJ'}}  $n2date\n\n\n";
		}

	last if (eof(INPUT));
	last if ($dtype eq "announce");
}
close(INPUT);
}

1;
