#!/usr/bin/perl -w
#
# Creates common environment for SVN/CVS repository
#
# $Id$
#

use strict;

# Expects we are in the right directory to launch CMS commands

sub cms_init {

my $ret;

system("cd $ENV{'PBROOT'} ; svn info . 2>&1 > /dev/null");
if ($? == -1) {
	print "failed to execute: $!\n";
} elsif ($? & 127) {
	printf "child died with signal %d, %s coredump\n", ($? & 127),  ($? & 128) ? 'with' : 'without';
} else {
	$ret =  $? >> 8;
	if ($ret == 0) {
		$ENV{'PBREVISION'}=`(cd "$ENV{'PBROOT'}" ; svnversion .)`;
		chomp($ENV{'PBREVISION'});
		$ENV{'PBCMSLOG'}="svn log";
		$ENV{'PBCMSLOGFILE'}="svn.log";
		$ENV{'PBCMSEXP'}="svn export";
	} else {
		# By default if not SVN take CVS
		$ENV{'PBREVISION'}=`(cd "$ENV{'PBROOT'}" ; cvs rannotate  -f . 2>&1 | awk '{print \$1}' | grep -E '^[0-9]' | cut -d. -f2 |sort -nu | tail -1)`;
		chomp($ENV{'PBREVISION'});
		$ENV{'PBCMSLOG'}="cvs log";
		$ENV{'PBCMSLOGFILE'}="cvs.log";
		$ENV{'PBCMSEXP'}="cvs export"
	}
}
}
1;
