#!/usr/bin/perl -w
#
# Creates common environment 
#
# $Id$
#

use strict;
use lib qw (lib);
use ProjectBuilder::pb qw (pb_init);
use File::Basename;
use File::Path;
use File::Temp qw /tempdir/;
use Data::Dumper;

$ENV{'PBETC'} = "$ENV{'HOME'}/.pbrc";

sub env_init {

my $proj=shift;
my $ver;
my $tag;

#
# Check project name
# Could be with env var PBPROJ
# or option -p
# if not define take the first in conf file
#
if ((defined $ENV{'PBPROJ'}) &&
	(not (defined $proj))) {
	$proj = $ENV{'PBPROJ'};
}
#
# Use project configuration file
#
pb_init("$ENV{'PBETC'}");

if (not defined $proj) {
	# Take the first as the default project
	$proj = (keys %pbroot)[0];
	print $LOG "Using $proj as default project as none has been specified\n" if (($debug >= 0) and (defined $proj));
}
die "No project defined - use env var PBPROJ or -p proj" if (not (defined $proj));

$ENV{'PBROOT'} = $pbroot{$proj}; 

#
# Check pb conf compliance
#
$ENV{'PBCONF'} = "$ENV{'PBROOT'}/pbconf";
die "Project $proj not Project-Builder compliant. Please populate $ENV{'PBCONF'}" if ( not -d "$ENV{'PBCONF'}");

if (-f "$ENV{'PBCONF'}/$proj.pb") {
	pb_conf_init("$ENV{'PBCONF'}/$proj.pb");
} else {
	die "Unable to open $ENV{'PBCONF'}/$proj.pb";
}

#
# Check content
#
if (defined $confparam{"cvsroot"}) {
	$ENV{'CVSROOT'} = $confparam{"cvsroot"}; 
}

die "defpkgdir doesn't exist in $ENV{'PBETC'}/$proj.pb" if (not (defined %defpkgdir));

#
# Set temp directory
#
if (not defined $ENV{'TMPDIR'}) {
	$ENV{'TMPDIR'}="/tmp";
}
$ENV{'PBTMP'} = tempdir( "pb.XXXXXXXXXX", DIR => $ENV{'TMPDIR'}, CLEANUP => 1 );

#
# Get global VERSION
#
open(VER, "$ENV{'PBCONF'}/VERSION") || die "Unable to open $ENV{'PBCONF'}/VERSION: $?";
$ver = <VER>;
chomp($ver);
#print Dumper(%version);
die "Invalid version name $ver in $ENV{'PBROOT'}/VERSION" if ($ver !~ /[0-9.]+/) && (not exists $version{$ver});
$ENV{'PBVER'}=$ver;
close(VER);

#
#Get global TAG
#
open(TAG, "$ENV{'PBCONF'}/TAG") || die "Unable to open $ENV{'PBCONF'}/TAG: $?";
$tag = <TAG>;
chomp($tag);
die "Invalid tag name $tag in $ENV{'PBROOT'}/TAG" if ($tag !~ /[0-9]+/);
$ENV{'PBTAG'}=$tag;
close(TAG);

#
# Adapt to your needs
# Set delivery directory
#
chdir "$ENV{'PBROOT'}/..";
my $path = `pwd`;
chomp($path);
$ENV{'PBTOPDIR'}=$path."/delivery";
$ENV{'PBDESTDIR'}="$ENV{'PBTOPDIR'}/$ENV{'PBVER'}-$ENV{'PBTAG'}";
if (-d $ENV{'PBDESTDIR'}) {
	opendir(DIR,$ENV{'PBDESTDIR'}) || die "Unable to open directory $ENV{'PBDESTDIR'}: $!";
	foreach my $d (readdir(DIR)) {
		next if ($d =~ /^\./);
		pbrm_rf("$ENV{'PBDESTDIR'}/$d") if (-d "$ENV{'PBDESTDIR'}/$d");
	}
	closedir(DIR);
}
if (! -d "$ENV{'PBDESTDIR'}") {
	pbmkdir_p($ENV{'PBDESTDIR'}) || die "Unable to recursively create $ENV{'PBDESTDIR'}";
}

#
# Set build directory
#
$ENV{'PBBUILDDIR'}=$path."/build";
pbrm_rf($ENV{'PBBUILDDIR'}) if (-d "$ENV{'PBBUILDDIR'}");
pbmkdir_p($ENV{'PBBUILDDIR'}) || die "Unable to recursively create $ENV{'PBBUILDDIR'}";

umask 0022;
return($proj);
}

sub pbmkdir_p {
my @dir = @_;
my $ret = mkpath(@dir, 0, 0755);
return($ret);
}

sub pbrm_rf {
my @dir = @_;
my $ret = rmtree(@dir, 0, 0);
return($ret);
}

sub pbsystem {

my $cmd=shift;
my $cmt=shift || $cmd;

print $LOG "$cmt... ";
system("$cmd");
if ($? == -1) {
	print $LOG "failed to execute: $!\n" if ($debug >= 0);
} elsif ($? & 127) {
	printf $LOG "child died with signal %d, %s coredump\n", ($? & 127),  ($? & 128) ? 'with' : 'without' if ($debug >= 0);
} else {
	print $LOG "OK\n" if ($debug >= 0);
}
}
1;
