#!/usr/bin/perl -w
#
# Project Builder configuration file
# For project pb ;-)
#
# $Id$
#
use strict;
use Exporter();
use vars qw(@ISA @EXPORT_OK);
@ISA = qw(Exporter);
# global vars are here
@EXPORT_OK = qw(%defpkgdir %extpkgdir @version &pb_init);
use vars @EXPORT_OK;
use AppConfig;

sub pb_init {

my $conffile = shift;

my $config = AppConfig->new({
							# Auto Create variables mentioned in Conf file
							CREATE => 1,
							DEBUG => 0,
							GLOBAL => {
							# Each conf item has one single parameter
							ARGCOUNT => AppConfig::ARGCOUNT_ONE
							}
						});
$config->file($conffile);

# Root of the project to build
# needs at least 2 levels of dir as in the upper 
# other dirs will be created and used
$ENV{'PBROOT'} = $config->get("pbproj");

# If CVS, gives the way to login
$ENV{'CVSROOT'} = $config->get("cvsroot");

# List of pkg to build by default
%defpkgdir = $config->get("defpkgdir");

# List of additional pkg to build when all is called
%extpkgdir = $config->get("extpkgdir");

# Valid version names
@version = $config->get("version");

}
1;
