#
# $Id: mindi.spec 1866 2008-01-16 15:29:04Z bruno $
#
%define perlvendorlib %(eval "`%{__perl} -V:installvendorlib`"; echo $installvendorlib)

Summary:	PBDESC
Name:		PBPKG
Version:	PBVER
Release:	PBTAGPBSUF
License:	PBLIC
Group:		PBGRP
Url:		PBURL
Source:		PBREPO/PBSRC
# Not yet possible as busybox is a binary that should go alongside
# BuildArch:	noarch
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(id -u -n)
BuildArch:	noarch
Requires:	bzip2 >= 0.9, mkisofs, binutils, gawk, dosfstools, parted, perl, mtools, perl-MondoRescue, PBDEP

%description
Mindi takes your kernel, modules, tools and libraries, and puts them on N
bootable disks (or 1 bootable CD image). You may then boot from the disks/CD
and do system maintenance - e.g. format partitions, backup/restore data,
verify packages, etc.

%prep
%setup -q

%build
%{__perl} Makefile.PL INSTALLDIRS=vendor PBKEYWORD=${RPM_BUILD_ROOT}/PBFINALDIR
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

# Finalyse instalation
export HEAD=${RPM_BUILD_ROOT}
export PREFIX=%{_exec_prefix}
export CONFDIR=%{_sysconfdir}
export CACHEDIR=%{_var}/cache/%{name}
export PKGBUILDMINDI="true"
./post-install.sh

find ${RPM_BUILD_ROOT} -type f -name perllocal.pod -o -name .packlist -o -name '*.bs' -a -size 0 | xargs rm -f
find ${RPM_BUILD_ROOT} -type d -depth | xargs rmdir --ignore-fail-on-non-empty

%check
make test

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%config(noreplace) %{_sysconfdir}/%{name}
%doc ChangeLog INSTALL COPYING README README.* NEWS 
%{_mandir}/man1/*
%{_mandir}/man3/*
%{_bindir}/*
%{_libdir}/%{name}
%{perlvendorlib}/*
%{_var}/cache/%{name}
%{_datadir}/PBPROJ/*

%changelog
PBLOG
