#
# $Id$
#

Name:           PBREALPKG
Version:        PBVER
Release:        PBTAGPBSUF
License:        PBLIC
Group:          PBGRP
Url:            PBURL
Source:         PBREPO/PBSRC
#PBPATCHSRC
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(id -u -n)
Requires:       postgresql php php-pear php-pgsql libxml2 binutils bzip2 cpio mkisofs poppler-utils rpm tar unzip gzip httpd which PBDEP
BuildRequires:  postgresql-devel libxml2 gcc make perl PBBUILDDEP
Summary:        FOSSology is a licenses exploration tool
Summary(fr):    FOSSology est un outil d'exploration de licenses

%package devel
Summary:        Devel part of FOSSology (a licenses exploration tool)
Summary(fr):    Partie dedévelopment de FOSSology, outil d'exploration de licenses
Group:          PBGRP

%description
PBDESC

%description -l fr
FOSSology est un outil d'exploration de licenses

%description devel
Devel part.
PBDESC

%description -l fr devel
Partie développement de FOSSology, outil d'exploration de licenses

%prep
%setup -q
#PBPATCHCMD

%build
make SYSCONFDIR=%{_sysconfdir}
#make %{?_smp_mflags} SYSCONFDIR=%{_sysconfdir}

%install
%{__rm} -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT PREFIX=%{_usr} SYSCONFDIR=%{_sysconfdir} LOCALSTATEDIR=%{_var} LIBDIR=%{_libdir} install
mkdir -p $RPM_BUILD_ROOT/%{_sysconfdir}/httpd/conf.d
cat > $RPM_BUILD_ROOT/%{_sysconfdir}/httpd/conf.d/PBPROJ.conf << EOF
Alias /repo/ /usr/share/PBPROJ/www/
<Directory "/usr/share/PBPROJ/www">
	AllowOverride None
	Options FollowSymLinks MultiViews
	Order allow,deny
	Allow from all
	# uncomment to turn on php error reporting 
	#php_flag display_errors on
	#php_value error_reporting 2039
</Directory>
EOF
cp utils/fo-cleanold $RPM_BUILD_ROOT/%{_usr}/lib/PBPROJ/

#rm -f $RPM_BUILD_ROOT/%{_sysconfdir}/default/PBPROJ

%clean
%{__rm} -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc ChangeLog
%doc COPYING COPYING.LGPL HACKING README INSTALL INSTALL.multi LICENSE 
#AUTHORS NEWS
%config(noreplace) %{_sysconfdir}/httpd/conf.d/*.conf
%config(noreplace) %{_sysconfdir}/cron.d/*
%config(noreplace) %{_sysconfdir}/PBPROJ/*
%dir %{_sysconfdir}/PBPROJ
%dir %{_usr}/lib/PBPROJ
%dir %{_datadir}/PBPROJ
%{_sysconfdir}/init.d/*
%{_usr}/lib/PBPROJ/*
%{_datadir}/PBPROJ/*
%{_bindir}/*
%{_mandir}/man1/*

%files devel
%{_includedir}/*
%{_libdir}/*.a

%post
# Adjust the kernel shmmax (described in detail in section 2.1.3)
echo 512000000 > /proc/sys/kernel/shmmax
grep -q kernel.shmmax /etc/sysctl.conf
if [ $? -eq 0 ]; then
	perl -pi -e "s/kernel.shmmax\s*=.*/kernel.shmmax=512000000/" /etc/sysctl.conf
else
	echo "kernel.shmmax=512000000" >> /etc/sysctl.conf
fi

if [ ! -f /usr/share/pgsql/postgresql.conf ]; then
	cp /usr/share/pgsql/postgresql.conf.sample /usr/share/pgsql/postgresql.conf
	
	# Adjust postgresql config (described in detail in section 2.1.4) for Fossology
	cat >> /usr/share/pgsql/postgresql.conf << EOF
listen_addresses = '*'
max_connections = 50
shared_buffers = 32768
work_mem = 10240  
max_fsm_pages = 100000		    # min max_fsm_relations*16, 6 bytes each
fsync = off   
full_page_writes = off	     	# recover from partial page writes
commit_delay = 1000 
effective_cache_size = 25000
log_min_duration_statement = -1	# -1 is disabled, 0 logs all statements
log_line_prefix = '%t %h %c'    # prepend a time stamp to all log entries
EOF
else
	echo "Please check that your postgresql configuration is aligned with fossology recommendations at section 2.1.4 of /usr/share/doc/fossology*/INSTALL"
fi

# Check postgresql is running
LANGUAGE=C /etc/init.d/postgresql status 2>&1 | grep -q stop
if [ $? -eq 0 ]; then
	/etc/init.d/postgresql start
else
	/etc/init.d/postgresql reload
fi

# Adjust PHP config (described in detail in section 2.1.5)
grep -qw memory_limit PBPHPINI
if [ $? -eq 0 ]; then
	perl -pi -e "s/memory_limit.*=.*/memory_limit = 702M/" PBPHPINI
else
	echo "memory_limit = 702M" >> PBPHPINI
fi
grep -qw post_max_size PBPHPINI
if [ $? -eq 0 ]; then
	perl -pi -e "s/post_max_size.*=.*/post_max_size = 702M/" PBPHPINI
else
	echo "post_max_size = 702M" >> PBPHPINI
fi
grep -qw upload_max_filesize PBPHPINI
if [ $? -eq 0 ]; then
	perl -pi -e "s/upload_max_filesize.*=.*/upload_max_filesize = 702M/" PBPHPINI
else
	echo "upload_max_filesize = 702M" >> PBPHPINI
fi

# Add apache config for fossology (described in detail in section 2.1.6) - done in install
LANGUAGE=C /etc/init.d/httpd status 2>&1 | grep -q stop
if [ $? -eq 0 ]; then
	/etc/init.d/httpd start
else
	/etc/init.d/httpd reload
fi

# Run the postinstall script
/usr/lib/PBPROJ/fo-postinstall

# Test that things are installed correctly
/usr/lib/PBPROJ/fossology-scheduler -t
if [ $? -ne 0 ]; then
	exit -1
fi

chkconfig --add PBPROJ
/etc/init.d/PBPROJ start

%preun
# If FOSSology is running, stop it before removing.
/etc/init.d/PBPROJ stop
chkconfig --del PBPROJ 2>&1 > /dev/null

# We should do some cleanup here (fossy account ...)
/usr/lib/PBPROJ/fo-cleanold
userdel fossy
groupdel fossy

%changelog
PBLOG
