Name: PBPKG
Version: PBVER
Release: PBTAGPBSUF
Summary: LinuxCOE SystemDesigner web interface

Group: PBGRP
License: GPL
URL: http://linuxcoe.sourceforge.net/
Source: PBSRC
BuildRoot: %(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)

BuildArch: noarch
#BuildRequires: ??
Requires: PBDEP
Provides: PBPROVIDE

%description
LinuxCOE SystemDesigner is a unifying web application that allows
a user to repeatably install, configure, and maintain different
Linux system installations. It's CGI-based interface provides means
to generate boot images for network or local media based installations,
save profiles that store custom installation preferences for later re-use,
and retrofit already deployed systems by overlaying other value-add components.

%prep

%setup -q

%build
./configure \
        webalias="PBwebalias" \
        webworkdir="PBwebworkdir" \
        httpdcfgdir="PBhttpdcfgdir" \
        httpd_user="PBhttpd_user" \
        httpd_group="PBhttpd_group" \
        sudoers_cfg="PBsudoers_cfg" \
        --prefix=PBprefix \
        --sysconfdir=PBsysconfdir \
        --localstatedir=%{_var} \
        --without-MKISOFS \
        --without-PERLMOD \
        --without-PALO \
        --without-SENDMAIL \
        --without-APACHECTL \
        --without-SUDO

%install
%{__rm} -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

# scriptlets

%clean
%{__rm} -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%config(noreplace) PBsysconfdir/linuxcoe.rc
%config(noreplace) PBsysconfdir/includes/LinuxCOE-SystemDesigner.conf
%config(noreplace) PBsysconfdir/includes/config.state
%config(noreplace) PBsysconfdir/includes/sudoers
%config(noreplace) %{_sysconfdir}/logrotate.d/LinuxCOE-SystemDesigner
%doc AUTHORS ChangeLog COPYING INSTALL NEWS README
%{_var}/cache/PBPROVIDE
%{_var}/lib/PBPROVIDE
%{_var}/log/PBPROVIDE
PBprefix

%post
# We should add a link so that Apache finds the new conf file
ln -sf PBsysconfdir/includes/LinuxCOE-SystemDesigner.conf /etc/httpd/conf.d

# httpd
LANGUAGE=C /etc/init.d/httpd status 2>&1 | grep -q stop
if [ $? -eq 0 ]; then
        /etc/init.d/httpd start
else
        /etc/init.d/httpd reload
fi
chkconfig --add httpd

%changelog
PBLOG
