#!/usr/bin/perl -w
#
# Creates common environment 
#
# $Id$
#
require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw(set_env);

use lib qw (lib);
use pb qw (pb_init);
use strict;
use File::Basename;
use ExtUtils::Command;
use File::Temp qw /tempdir/;
use vars qw (%defpkgdir %extpkgdir %version);
use Data::Dumper;

$ENV{'PBCONF'} = "/etc/pb";

sub set_env {

my $proj=shift;
my $ver;
my $tag;

#
# Check project name
#
if ((defined $ENV{'PBPROJ'}) &&
	(not (defined $proj))) {
	$proj = $ENV{'PBPROJ'};
}
die "No project defined - use env var PBPROJ or -p proj" if (not (defined $proj));

#
# Use project configuration file
#
pb_init("$ENV{'PBCONF'}/$proj.pb");

#
# Check content
#
die "PBROOT doesn't exist in $ENV{'PBCONF'}/$proj.pb" if (not (defined $ENV{'PBROOT'}));
die "defpkgdir doesn't exist in $ENV{'PBCONF'}/$proj.pb" if (not (defined %defpkgdir));

#
# Set temp directory
#
if (not defined $ENV{'TMPDIR'}) {
	$ENV{'TMPDIR'}="/tmp";
}
$ENV{'PBTMP'} = tempdir( "pb.XXXXXXXXXX", DIR => $ENV{'TMPDIR'}, CLEANUP => 1 );

#
# Check pb conf compliance
#
die "Project $ENV{'PBPROJ'} not ProjectBuild compliant. Please populate $ENV{'PBROOT'}/pbconf" if ( not -d "$ENV{'PBROOT'}/pbconf");

#
# Get global VERSION
#
open(VER, "$ENV{'PBROOT'}/pbconf/VERSION") || die "Unable to open $ENV{'PBROOT'}/pbconf/VERSION: $?";
$ver = <VER>;
chomp($ver);
#print Dumper(%version);
die "Invalid version name $ver in $ENV{'PBROOT'}/VERSION" if ($ver !~ /[0-9.]+/) && (not exists $version{$ver});
$ENV{'PBVER'}=$ver;
close(VER);

#
#Get global TAG
#
open(TAG, "$ENV{'PBROOT'}/pbconf/TAG") || die "Unable to open $ENV{'PBROOT'}/pbconf/TAG: $?";
$tag = <TAG>;
chomp($tag);
die "Invalid tag name $tag in $ENV{'PBROOT'}/TAG" if ($tag !~ /[0-9]+/);
$ENV{'PBTAG'}=$tag;
close(TAG);

#
# Adapt to your needs
# Set delivery directory
#
$ENV{'PBTOPDIR'}="$ENV{'PBROOT'}/../delivery";
$ENV{'PBDESTDIR'}=$ENV{'PBTOPDIR'}."/".$ENV{'PBVER'}."-".$ENV{'PBTAG'};
mkpath $ENV{'PBDESTDIR'};

umask 0022;
return($proj);
}
1;
