#!/usr/bin/perl -w
#
# Project Builder configuration file
# For project pb ;-)
#
# $Id$
#
use strict;
use Exporter();
use vars qw(@ISA @EXPORT_OK);
@ISA = qw(Exporter);
# global vars are here
@EXPORT_OK = qw(%defpkgdir %extpkgdir %version &pb_init);
use vars @EXPORT_OK;
use AppConfig qw(ARGCOUNT_ONE ARGCOUNT_HASH ARGCOUNT_LIST EXPAND_ALL);

sub pb_init {

my $conffile = shift;
my $ptr;

my $config = AppConfig->new({
							# Auto Create variables mentioned in Conf file
							CREATE => 1,
							DEBUG => 0,
						});
$config->define("pbroot" => { ARGCOUNT => ARGCOUNT_ONE, EXPAND => EXPAND_ALL });
$config->define("cvsroot" => { ARGCOUNT => ARGCOUNT_ONE });
$config->define("defpkgdir" => { ARGCOUNT => ARGCOUNT_HASH });
$config->define("extpkgdir" => { ARGCOUNT => ARGCOUNT_HASH });
$config->define("version" => { ARGCOUNT => ARGCOUNT_HASH });

$config->file($conffile);

# Root of the project to build
# needs at least 2 levels of dir as in the upper 
# other dirs will be created and used
$ENV{'PBROOT'} = $config->get("pbroot") || die "Unable to find pbroot in $conffile";

# If CVS, gives the way to login
$ENV{'CVSROOT'} = $config->get("cvsroot");

# List of pkg to build by default
$ptr = $config->get("defpkgdir") || die "Unable to find defpkgdir in $conffile";
%defpkgdir = %$ptr;

# List of additional pkg to build when all is called
$ptr = $config->get("extpkgdir");
%extpkgdir = %$ptr;

# Valid version names
$ptr = $config->get("version");
%version = %$ptr;

}
1;
