#!/usr/bin/perl -w
#
# Project Builder main application
#
# $Id$
#
# Copyright B. Cornec 2007
# Provided under the GPL v2

# Syntax: pb [-p project] <action> [<params>...]

use strict;
use Switch;
use Getopt::Std;
use Data::Dumper;
use English;

use lib qw (lib etc);
use vars qw (%defpkgdir %extpkgdir %version);
use common qw (env_init);
use pb qw (defpkgdir extpkgdir version pb_init);
use cms;

my %opts;					# CLI Options
my $action;					# action to realize
my $test = "FALSE";
my $option = "";
my @pkgs;

getopts('p:t',\%opts);

# Handles project name if any
if (defined $opts{'p'}) {
	$ENV{'PBPROJ'} = env_init($opts{'p'});
} else {
	$ENV{'PBPROJ'} = env_init();
}
# Handles test option
if (defined $opts{'t'}) {
	$test = "TRUE";
	# Works only for SVN
	$option = "-r BASE";
}

# Get Action
$action = shift @ARGV;
die "Syntax: pb [-p project] <action> [<params>...]" if (not defined $action);

print "Project $ENV{'PBPROJ'}\n";
#print "Action: $action - ARGV:".Dumper(\@ARGV);

# Act depending on action
if ($action =~ /^cms2build$/) {
	print "Action: cms2build\n";
	# Get packages list
	if (not defined $ARGV[0]) {
		@pkgs = keys %defpkgdir;
	} elsif ($ARGV[0] =~ /^all$/) {
		@pkgs = keys %defpkgdir;
		push(@pkgs, keys %extpkgdir);
	} else {
		@pkgs = @ARGV;
	}
	print "Packages:\n";
	print Dumper(@pkgs);
	cms_init();

	foreach my $p (@pkgs) {

		my $v;

		if (-f "$ENV{'PBROOT'}/$p/VERSION") {
			open(V,"$ENV{'PBROOT'}/$p/VERSION") || die "Unable to open $ENV{'PBROOT'}/$p/VERSION";
			$v = <V>;
			chomp($v);
			close(V);
		} else {
			$v = $ENV{'PBVER'};
		}

		my $tag;

		if (-f "$ENV{'PBROOT'}/$p/TAG") {
			open(T,"$ENV{'PBROOT'}/$p/TAG") || die "Unable to open $ENV{'PBROOT'}/$p/TAG";
			$tag = <T>;
			chomp($tag);
			close(T);
		} else {
			$tag = $ENV{'PBTAG'};
		}
		print "Management of $p $v-$tag (rev $ENV{'PBREVISION'})\n";
		die "Unable to get env var PBDESTDIR" if (not defined $ENV{'PBDESTDIR'});
		# Clean up dest if necessary
		my $dest = "$ENV{'PBDESTDIR'}/$p-$v";
		pbrm_rf($dest) if (-d $dest);

		# Export CMS tree for the concerned package to dest
		# And generate some additional files
		$OUTPUT_AUTOFLUSH=1;
		print "$ENV{'PBCMSEXP'} of $p...";
		# computes in which dir we have to work
		my $dir = $defpkgdir{$p};
		$dir = $extpkgdir{$p} if (not defined $dir);
		system("$ENV{'PBCMSEXP'} $option $ENV{'PBROOT'}/$dir $dest 1>/dev/null");
		if ($? == -1) {
			print "failed to execute: $!\n";
		} elsif ($? & 127) {
			printf "child died with signal %d, %s coredump\n", ($? & 127),  ($? & 128) ? 'with' : 'without';
		} else {
			print " Done under $dest\n";
		}

		# Creates a REVISION file
		open(R,"> $dest/REVISION") || die "Unable to create $dest/REVISION";
		print R "$ENV{'PBREVISION'}\n";
		close(R);

		# Extract cms log history and store it
		system("$ENV{'PBCMSLOG'} $option $ENV{'PBROOT'}/$dir > $dest/$ENV{'PBCMSLOGFILE'}");
		print "$ENV{'PBCMSLOG'} of $p...";
		if ($? == -1) {
			print "failed to execute: $!\n";
		} elsif ($? & 127) {
			printf "child died with signal %d, %s coredump\n", ($? & 127),  ($? & 128) ? 'with' : 'without';
		} else {
			print " OK\n";
		}
	}
} else {
	print "'$action' is not available\n";
	print "Available actions are:\n";
	print "    cms2build\n";
}
